/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.interceptor;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.interceptor.Blog;
import org.hibernate.search.test.interceptor.BlogStatus;
import org.hibernate.search.test.util.TestForIssue;
import org.junit.Assert;

@TestForIssue(jiraKey="HSEARCH-1190")
public class InterceptedMassIndexerTest
extends SearchTestCase {
    public void testMassIndexerSkips() throws InterruptedException {
        this.storeSomeBlogs();
        this.assertIndexedBooks(2);
        this.rebuildIndexes();
        this.assertIndexedBooks(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndexes() throws InterruptedException {
        Session session = this.openSession();
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            fullTextSession.createIndexer(new Class[]{Blog.class}).startAndWait();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIndexedBooks(int expectedBooks) {
        Session session = this.openSession();
        try {
            Transaction transaction = session.beginTransaction();
            try {
                FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
                MatchAllDocsQuery allQuery = new MatchAllDocsQuery();
                FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)allQuery, new Class[]{Blog.class});
                int resultSize = fullTextQuery.getResultSize();
                Assert.assertEquals((long)expectedBooks, (long)resultSize);
            }
            finally {
                transaction.commit();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSomeBlogs() {
        Session session = this.openSession();
        try {
            Transaction transaction = session.beginTransaction();
            try {
                Blog beta1 = new Blog();
                beta1.setTitle("Hibernate Search 4.2.0.Beta1 is ready!!");
                beta1.setStatus(BlogStatus.PUBLISHED);
                session.save((Object)beta1);
                Blog lucene4 = new Blog();
                lucene4.setTitle("Apache Lucene 4 is ready. Now you can rewrite all your code from scratch!");
                lucene4.setStatus(BlogStatus.PUBLISHED);
                session.save((Object)lucene4);
                Blog beta2 = new Blog();
                beta2.setTitle("More Spatial, easy clustering, and JMX improvements");
                beta2.setStatus(BlogStatus.DRAFT);
                session.save((Object)beta2);
            }
            finally {
                transaction.commit();
            }
        }
        finally {
            session.close();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Blog.class};
    }
}

