/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jms.slave;

import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.spi.IndexManager;

public class SearchQueueChecker
implements MessageListener {
    public static int queues;
    public static int works;
    private SearchFactoryImplementor searchFactory;

    public SearchQueueChecker(SearchFactoryImplementor searchFactory) {
        this.searchFactory = searchFactory;
    }

    public static void reset() {
        queues = 0;
        works = 0;
    }

    public void onMessage(Message message) {
        List queue;
        if (!(message instanceof ObjectMessage)) {
            return;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            String indexName = objectMessage.getStringProperty("HSearchIndexName");
            IndexManager indexManager = this.searchFactory.getIndexManagerHolder().getIndexManager(indexName);
            queue = indexManager.getSerializer().toLuceneWorks((byte[])objectMessage.getObject());
        }
        catch (JMSException e) {
            return;
        }
        catch (ClassCastException e) {
            return;
        }
        ++queues;
        works += queue.size();
    }
}

