/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.SkipLog;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.util.StringHelper;
import org.hibernate.testing.FailureExpected;
import org.hibernate.testing.SkipForDialect;

public abstract class SearchTestCase
extends TestCase
implements TestResourceManager {
    private DefaultTestResourceManager testResourceManager;

    public void setUp() throws Exception {
        DefaultTestResourceManager testResourceManager = this.getTestResourceManager();
        if (testResourceManager.needsConfigurationRebuild()) {
            this.configure(testResourceManager.getCfg());
            testResourceManager.buildConfiguration();
        }
        testResourceManager.openSessionFactory();
    }

    public void tearDown() throws Exception {
        this.getTestResourceManager().defaultTearDown();
    }

    @Override
    public final Configuration getCfg() {
        return this.getTestResourceManager().getCfg();
    }

    @Override
    public final void openSessionFactory() {
        this.getTestResourceManager().openSessionFactory();
    }

    @Override
    public SearchFactory getSearchFactory() {
        return this.getTestResourceManager().getSearchFactory();
    }

    @Override
    public final SessionFactory getSessionFactory() {
        return this.getTestResourceManager().getSessionFactory();
    }

    @Override
    public final void closeSessionFactory() {
        this.getTestResourceManager().closeSessionFactory();
    }

    @Override
    public SearchFactoryImplementor getSearchFactoryImpl() {
        return this.getTestResourceManager().getSearchFactoryImpl();
    }

    @Override
    public final Session openSession() {
        return this.getTestResourceManager().openSession();
    }

    @Override
    public final Session getSession() {
        return this.getTestResourceManager().getSession();
    }

    @Override
    public File getBaseIndexDir() {
        return this.getTestResourceManager().getBaseIndexDir();
    }

    @Override
    public void ensureIndexesAreEmpty() {
        this.getTestResourceManager().ensureIndexesAreEmpty();
    }

    @Override
    public Directory getDirectory(Class<?> clazz) {
        return this.getTestResourceManager().getDirectory(clazz);
    }

    @Override
    public void forceConfigurationRebuild() {
        this.getTestResourceManager().forceConfigurationRebuild();
    }

    @Override
    public boolean needsConfigurationRebuild() {
        return this.getTestResourceManager().needsConfigurationRebuild();
    }

    protected abstract Class<?>[] getAnnotatedClasses();

    protected void configure(Configuration cfg) {
        this.getTestResourceManager().applyDefaultConfiguration(cfg);
    }

    protected void runTest() throws Throwable {
        Method runMethod = this.findTestMethod();
        FailureExpected failureExpected = this.locateAnnotation(FailureExpected.class, runMethod);
        try {
            super.runTest();
            if (failureExpected != null) {
                throw new FailureExpectedTestPassedException();
            }
        }
        catch (FailureExpectedTestPassedException t) {
            throw t;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof IllegalAccessException) {
                t.fillInStackTrace();
            }
            if (failureExpected != null) {
                StringBuilder builder = new StringBuilder();
                if (StringHelper.isNotEmpty((String)failureExpected.message())) {
                    builder.append(failureExpected.message());
                } else {
                    builder.append("ignoring @FailureExpected test");
                }
                builder.append(" (").append(failureExpected.jiraKey()).append(")");
                SkipLog.LOG.warn(builder.toString(), t);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        Method runMethod = this.findTestMethod();
        Skip skip = this.determineSkipByDialect(Dialect.getDialect(), runMethod);
        if (skip != null) {
            this.reportSkip(skip);
            return;
        }
        this.setUp();
        try {
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    private synchronized DefaultTestResourceManager getTestResourceManager() {
        if (this.testResourceManager == null) {
            this.testResourceManager = new DefaultTestResourceManager(this.getAnnotatedClasses());
        }
        return this.testResourceManager;
    }

    private void reportSkip(Skip skip) {
        this.reportSkip(skip.reason, skip.testDescription);
    }

    private void reportSkip(String reason, String testDescription) {
        StringBuilder builder = new StringBuilder();
        builder.append("*** skipping test [");
        builder.append(this.fullTestName());
        builder.append("] - ");
        builder.append(testDescription);
        builder.append(" : ");
        builder.append(reason);
        SkipLog.LOG.warn(builder.toString());
    }

    private Skip buildSkip(Dialect dialect, String comment, String jiraKey) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("skipping database-specific test [");
        buffer.append(this.fullTestName());
        buffer.append("] for dialect [");
        buffer.append(dialect.getClass().getName());
        buffer.append(']');
        if (StringHelper.isNotEmpty((String)comment)) {
            buffer.append("; ").append(comment);
        }
        if (StringHelper.isNotEmpty((String)jiraKey)) {
            buffer.append(" (").append(jiraKey).append(')');
        }
        return new Skip(buffer.toString(), null);
    }

    private <T extends Annotation> T locateAnnotation(Class<T> annotationClass, Method runMethod) {
        T annotation = runMethod.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = this.getClass().getAnnotation(annotationClass);
        }
        if (annotation == null) {
            annotation = runMethod.getDeclaringClass().getAnnotation(annotationClass);
        }
        return annotation;
    }

    private Skip determineSkipByDialect(Dialect dialect, Method runMethod) throws Exception {
        SkipForDialect skipForDialectAnn = this.locateAnnotation(SkipForDialect.class, runMethod);
        if (skipForDialectAnn != null) {
            for (Class dialectClass : skipForDialectAnn.value()) {
                if (!(skipForDialectAnn.strictMatching() ? dialectClass.equals(dialect.getClass()) : dialectClass.isInstance(dialect))) continue;
                return this.buildSkip(dialect, skipForDialectAnn.comment(), skipForDialectAnn.jiraKey());
            }
        }
        return null;
    }

    private String fullTestName() {
        return this.getClass().getName() + "#" + this.getName();
    }

    private Method findTestMethod() {
        String fName = this.getName();
        SearchTestCase.assertNotNull((Object)fName);
        Method runMethod = null;
        try {
            runMethod = this.getClass().getMethod(fName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            SearchTestCase.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            SearchTestCase.fail((String)("Method \"" + fName + "\" should be public"));
        }
        return runMethod;
    }

    private static class Skip {
        private final String reason;
        private final String testDescription;

        public Skip(String reason, String testDescription) {
            this.reason = reason;
            this.testDescription = testDescription;
        }
    }

    private static class FailureExpectedTestPassedException
    extends Exception {
        public FailureExpectedTestPassedException() {
            super("Test marked as @FailureExpected, but did not fail!");
        }
    }
}

