/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.slave;

import java.util.List;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.impl.jgroups.MessageSerializationHelper;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;

public class JGroupsReceiver
extends ReceiverAdapter {
    public static volatile int queues;
    public static volatile int works;
    private SearchFactoryImplementor searchFactory;

    public JGroupsReceiver(SearchFactoryImplementor searchFactory) {
        this.searchFactory = searchFactory;
    }

    public static void reset() {
        queues = 0;
        works = 0;
    }

    public void receive(Message message) {
        try {
            byte[] rawBuffer = message.getRawBuffer();
            int messageOffset = message.getOffset();
            int bufferLength = message.getLength();
            String indexName = MessageSerializationHelper.extractIndexName((int)messageOffset, (byte[])rawBuffer);
            byte[] serializedQueue = MessageSerializationHelper.extractSerializedQueue((int)messageOffset, (int)bufferLength, (byte[])rawBuffer);
            IndexManager indexManager = this.searchFactory.getIndexManagerHolder().getIndexManager(indexName);
            List queue = indexManager.getSerializer().toLuceneWorks(serializedQueue);
            ++queues;
            works += queue.size();
        }
        catch (ClassCastException e) {
            throw new SearchException((Throwable)e);
        }
    }
}

