/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.lang.reflect.Method;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;

public final class ServiceRegistryTools {
    private static final Method builderMethod = ServiceRegistryTools.identifyCorrectBuilderMethod();

    private ServiceRegistryTools() {
    }

    public static ServiceRegistry build(ServiceRegistryBuilder registryBuilder) {
        try {
            return (ServiceRegistry)builderMethod.invoke((Object)registryBuilder, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method identifyCorrectBuilderMethod() {
        try {
            return ServiceRegistryBuilder.class.getMethod("build", new Class[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            try {
                return ServiceRegistryBuilder.class.getMethod("buildServiceRegistry", new Class[0]);
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }
}

