/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.depth;

import java.io.Serializable;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ReaderUtil;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.depth.WorkingPerson;
import org.hibernate.search.test.util.LeakingLuceneBackend;
import org.hibernate.testing.SkipForDialect;

@SkipForDialect(comment="looks like a database deadlock", value={SybaseASE15Dialect.class}, jiraKey="HSEARCH-1107")
public class WorkDoneOnEntitiesTest
extends SearchTestCase {
    private Session session = null;

    public void testEmployeesIndexingInDepth() throws Exception {
        List<WorkingPerson> result = this.search(this.session, "employees.name", "Technical Manager");
        WorkDoneOnEntitiesTest.assertEquals((String)"Unexpected number of results", (int)1, (int)result.size());
        WorkDoneOnEntitiesTest.assertEquals((String)"Should be able to index field inside depth and in path", (String)"Real estate director", (String)result.get((int)0).name);
        this.checkRawIndexFields();
    }

    public void testParentsIndexingInDepth() throws Exception {
        List<WorkingPerson> result = this.search(this.session, "parents.parents.name", "Empress Matilda");
        WorkDoneOnEntitiesTest.assertEquals((String)"Unexpected number of results", (int)1, (int)result.size());
        WorkDoneOnEntitiesTest.assertEquals((String)"Should be able to index field inside depth and in path", (String)"John of England", (String)result.get((int)0).name);
        result = this.search(this.session, "parents.parents.parents.name", "Ermengarde of Maine");
        WorkDoneOnEntitiesTest.assertEquals((String)"Unexpected number of results", (int)1, (int)result.size());
        this.checkRawIndexFields();
    }

    public void testNoWorkShouldBeExecutedOnPerson() throws Exception {
        this.renamePerson(this.session, 17, "Montford");
        this.checkRawIndexFields();
        WorkDoneOnEntitiesTest.assertEquals((int)0, (int)this.countWorksDoneOnPersonId(1));
    }

    public void testWorkShouldBeExecutedOnPerson() throws Exception {
        this.renamePerson(this.session, 6, "William");
        this.checkRawIndexFields();
        WorkDoneOnEntitiesTest.assertEquals((int)1, (int)this.countWorksDoneOnPersonId(1));
    }

    public void testNoWorkShouldBeExecutedOnEmployee() throws Exception {
        this.renamePerson(this.session, 23, "LM");
        this.checkRawIndexFields();
        WorkDoneOnEntitiesTest.assertEquals((int)0, (int)this.countWorksDoneOnPersonId(1));
    }

    public void testWorkShouldBeExecutedOnEmployee() throws Exception {
        this.renamePerson(this.session, 19, "FM");
        this.checkRawIndexFields();
        WorkDoneOnEntitiesTest.assertEquals((int)1, (int)this.countWorksDoneOnPersonId(1));
    }

    public void testShouldNotIndexParentsBeyondDepth() throws Exception {
        try {
            this.search(this.session, "parents.parents.parents.parents.name", "Bertrade de Montfort");
            WorkDoneOnEntitiesTest.fail((String)"Should not index a field if it is beyond the depth threshold");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
        this.checkRawIndexFields();
    }

    public void testShouldNotIndexBeyondMixedPathDepth() throws Exception {
        try {
            this.search(this.session, "parents.employees.employees.name", "Techincal Manager");
            WorkDoneOnEntitiesTest.fail((String)"Should not index a field if it is beyond the depth threshold, considering minimum depth along paths");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
        this.checkRawIndexFields();
    }

    public void testShouldNotIndexEmployeesBeyondDepth() throws Exception {
        try {
            this.search(this.session, "employees.employees.name", "Techincal Manager");
            WorkDoneOnEntitiesTest.fail((String)"Should not index a field if it is beyond the depth threshold");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
        this.checkRawIndexFields();
    }

    private void checkRawIndexFields() {
        Assert.assertTrue((boolean)this.indexContainsField("name"));
        Assert.assertTrue((boolean)this.indexContainsField("employees.name"));
        Assert.assertTrue((boolean)this.indexContainsField("parents.name"));
        Assert.assertTrue((boolean)this.indexContainsField("parents.parents.name"));
        Assert.assertTrue((boolean)this.indexContainsField("parents.parents.parents.name"));
        Assert.assertTrue((boolean)this.indexContainsField("parents.employees.name"));
        Assert.assertTrue((boolean)this.indexContainsField("parents.parents.employees.name"));
        Assert.assertFalse((boolean)this.indexContainsField("employees.employees.name"));
        Assert.assertFalse((boolean)this.indexContainsField("employees.parents.name"));
        Assert.assertFalse((boolean)this.indexContainsField("parents.employees.employees.name"));
        Assert.assertFalse((boolean)this.indexContainsField("parents.parents.parents.employees.name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean indexContainsField(String fieldName) {
        IndexReaderAccessor indexReaderAccessor = this.getSearchFactory().getIndexReaderAccessor();
        IndexReader indexReader = indexReaderAccessor.open(new Class[]{WorkingPerson.class});
        try {
            boolean bl = ReaderUtil.getIndexedFields((IndexReader)indexReader).contains(fieldName);
            return bl;
        }
        finally {
            indexReaderAccessor.close(indexReader);
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session = this.openSession();
        Transaction transaction = this.session.beginTransaction();
        WorkingPerson[] ps = new WorkingPerson[27];
        ps[1] = new WorkingPerson(1, "John of England");
        ps[2] = new WorkingPerson(2, "Henry II of England");
        ps[3] = new WorkingPerson(3, "Eleanor of Aquitaine");
        ps[4] = new WorkingPerson(4, "Geoffrey V of Anjou");
        ps[5] = new WorkingPerson(5, "Empress Matilda");
        ps[6] = new WorkingPerson(6, "William X of Aquitaine");
        ps[7] = new WorkingPerson(7, "Aenor de Ch\u00e2tellerault");
        ps[8] = new WorkingPerson(8, "Fulk V of Anjou");
        ps[9] = new WorkingPerson(9, "Ermengarde of Maine");
        ps[10] = new WorkingPerson(10, "Henry I of England");
        ps[11] = new WorkingPerson(11, "Matilda of Scotland");
        ps[12] = new WorkingPerson(12, "William IX of Aquitaine");
        ps[13] = new WorkingPerson(13, "Philippa of Toulouse");
        ps[14] = new WorkingPerson(14, "Aimery I of Ch\u00e2ttellerault");
        ps[15] = new WorkingPerson(15, "Dangereuse de L'Isle Bouchard");
        ps[16] = new WorkingPerson(16, "Fulk IV of Anjou");
        ps[17] = new WorkingPerson(17, "Bertrade de Montfort");
        ps[18] = new WorkingPerson(18, "Real estate director");
        ps[19] = new WorkingPerson(19, "Financial Director");
        ps[20] = new WorkingPerson(20, "Technical Manager");
        ps[21] = new WorkingPerson(21, "Leasing Manager");
        ps[22] = new WorkingPerson(22, "Financial Analyst");
        ps[23] = new WorkingPerson(23, "Internal Audit Manager");
        ps[24] = new WorkingPerson(24, "Slave of Henry II");
        ps[25] = new WorkingPerson(25, "Slave of Geoffrey V");
        ps[26] = new WorkingPerson(26, "Assistant of Slave of Geoffrey V");
        ps[1].addParents(ps[2], ps[3]);
        ps[2].addParents(ps[4], ps[5]);
        ps[4].addParents(ps[8], ps[9]);
        ps[8].addParents(ps[16], ps[17]);
        ps[5].addParents(ps[10], ps[11]);
        ps[3].addParents(ps[6], ps[7]);
        ps[6].addParents(ps[12], ps[13]);
        ps[7].addParents(ps[14], ps[15]);
        ps[1].addEmployees(ps[18], ps[19]);
        ps[2].addEmployees(ps[24]);
        ps[5].addEmployees(ps[25]);
        ps[25].addEmployees(ps[26]);
        ps[18].addEmployees(ps[20], ps[21]);
        ps[19].addEmployees(ps[22], ps[23]);
        for (int i = 1; i < ps.length; ++i) {
            this.session.save((Object)ps[i]);
        }
        transaction.commit();
        LeakingLuceneBackend.reset();
    }

    @Override
    public void tearDown() throws Exception {
        this.session.clear();
        this.deleteAll(this.session, WorkingPerson.class);
        this.session.close();
        LeakingLuceneBackend.reset();
        super.tearDown();
    }

    private List<WorkingPerson> search(Session s, String field, String value) {
        FullTextSession session = Search.getFullTextSession((Session)s);
        List result = session.createFullTextQuery(this.searchQuery(field, value, session), new Class[0]).list();
        return result;
    }

    private Query searchQuery(String field, String value, FullTextSession session) {
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(WorkingPerson.class).get();
        return queryBuilder.keyword().onField(field).matching((Object)value).createQuery();
    }

    private void deleteAll(Session s, Class<?> ... classes) {
        Transaction tx = s.beginTransaction();
        for (Class<?> each : classes) {
            List list = s.createCriteria(each).list();
            for (Object object : list) {
                s.delete(object);
            }
        }
        tx.commit();
    }

    private void renamePerson(Session s, Integer id, String newName) {
        Transaction transaction = s.beginTransaction();
        WorkingPerson person = (WorkingPerson)s.load(WorkingPerson.class, (Serializable)id);
        person.name = newName;
        transaction.commit();
    }

    private int countWorksDoneOnPersonId(Integer pk) {
        List processedQueue = LeakingLuceneBackend.getLastProcessedQueue();
        int count = 0;
        for (LuceneWork luceneWork : processedQueue) {
            Serializable id = luceneWork.getId();
            if (!pk.equals(id)) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{WorkingPerson.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName());
    }
}

