/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.nested.containedIn;

import java.io.Serializable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.nested.containedIn.Entity1ForDoc0;
import org.hibernate.search.test.embedded.nested.containedIn.Entity1ForUnindexed;
import org.hibernate.search.test.embedded.nested.containedIn.Entity2ForDoc0;
import org.hibernate.search.test.embedded.nested.containedIn.Entity2ForUnindexed;
import org.hibernate.testing.cache.CachingRegionFactory;

public class LazyM2OContainedInTest
extends SearchTestCase {
    public void testDocumentsAt0() {
        FullTextSession fts = Search.getFullTextSession((Session)this.getSessionFactory().openSession());
        Transaction tx = fts.beginTransaction();
        Entity1ForDoc0 ent1 = new Entity1ForDoc0();
        Entity2ForDoc0 ent2 = new Entity2ForDoc0();
        ent2.setEntity1(ent1);
        ent1.getEntities2().add(ent2);
        ent2.setName("test - 1");
        fts.persist((Object)ent1);
        fts.persist((Object)ent2);
        tx.commit();
        long uid2 = ent2.getUid();
        long uid1 = ent1.getUid();
        fts.clear();
        tx = fts.beginTransaction();
        LazyM2OContainedInTest.assertEquals((int)1, (int)fts.createFullTextQuery((Query)new TermQuery(new Term("uid", new Long(uid1).toString())), new Class[]{Entity1ForDoc0.class}).getResultSize());
        LazyM2OContainedInTest.assertEquals((int)1, (int)fts.createFullTextQuery((Query)new TermQuery(new Term("entities2.uid", String.valueOf(uid2))), new Class[]{Entity1ForDoc0.class}).getResultSize());
        tx.commit();
        tx = fts.beginTransaction();
        for (Object e : fts.createCriteria(Entity2ForDoc0.class).list()) {
            fts.delete(e);
        }
        for (Object e : fts.createCriteria(Entity1ForDoc0.class).list()) {
            fts.delete(e);
        }
        tx.commit();
    }

    public void testContainedInAndLazy() {
        FullTextSession fts = Search.getFullTextSession((Session)this.getSessionFactory().openSession());
        Entity1ForUnindexed ent1_0 = new Entity1ForUnindexed();
        Entity1ForUnindexed ent1_1 = new Entity1ForUnindexed();
        Entity2ForUnindexed ent2_0 = new Entity2ForUnindexed();
        Entity2ForUnindexed ent2_1 = new Entity2ForUnindexed();
        ent2_0.setEntity1(ent1_0);
        ent1_0.getEntities2().add(ent2_0);
        ent2_1.setEntity1(ent1_1);
        ent1_1.getEntities2().add(ent2_1);
        fts.persist((Object)ent1_0);
        fts.persist((Object)ent1_1);
        fts.persist((Object)ent2_0);
        fts.persist((Object)ent2_1);
        Transaction tx = fts.beginTransaction();
        tx.commit();
        fts.clear();
        Entity1ForUnindexed other = new Entity1ForUnindexed();
        fts.persist((Object)other);
        fts.getTransaction().begin();
        fts.getTransaction().commit();
        fts.clear();
        long otherId = other.getUid();
        LazyM2OContainedInTest.assertEquals((int)1, (int)fts.createFullTextQuery((Query)new TermQuery(new Term("entity1.uid", new Long(ent1_0.getUid()).toString())), new Class[]{Entity2ForUnindexed.class}).getResultSize());
        Entity1ForUnindexed toDelete = (Entity1ForUnindexed)fts.get(Entity1ForUnindexed.class, (Serializable)Long.valueOf(otherId));
        fts.delete((Object)toDelete);
        fts.getTransaction().begin();
        fts.getTransaction().commit();
        fts.clear();
        LazyM2OContainedInTest.assertEquals((int)0, (int)fts.createFullTextQuery((Query)new TermQuery(new Term("entity1.uid", String.valueOf(otherId))), new Class[]{Entity2ForUnindexed.class}).getResultSize());
        tx = fts.beginTransaction();
        for (Object e : fts.createCriteria(Entity2ForUnindexed.class).list()) {
            fts.delete(e);
        }
        for (Object e : fts.createCriteria(Entity1ForUnindexed.class).list()) {
            fts.delete(e);
        }
        tx.commit();
        fts.close();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.cache.region.factory_class", CachingRegionFactory.class.getName());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Entity1ForDoc0.class, Entity2ForDoc0.class, Entity1ForUnindexed.class, Entity2ForUnindexed.class};
    }
}

