/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.errorhandling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.StreamingSelectionVisitor;
import org.hibernate.search.backend.impl.WorkVisitor;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.errorhandling.Foo;
import org.hibernate.search.test.errorhandling.MockErrorHandler;

public class LuceneErrorHandlingTest
extends SearchTestCase {
    static final AtomicInteger WORK_COUNTER = new AtomicInteger();

    public void testErrorHandling() {
        MockErrorHandler mockErrorHandler = this.getErrorHandlerAndAssertCorrectTypeIsUsed();
        EntityIndexBinding mappingForEntity = this.getSearchFactoryImpl().getIndexBinding(Foo.class);
        IndexManager indexManager = mappingForEntity.getIndexManagers()[0];
        ArrayList<DeleteLuceneWork> queue = new ArrayList<DeleteLuceneWork>();
        queue.add(new HarmlessWork("firstWork"));
        queue.add(new HarmlessWork("secondWork"));
        WORK_COUNTER.set(0);
        indexManager.performOperations(queue, null);
        Assert.assertEquals((int)2, (int)WORK_COUNTER.get());
        WORK_COUNTER.set(0);
        FailingWork firstFailure = new FailingWork("firstFailure");
        queue.add(firstFailure);
        HarmlessWork thirdWork = new HarmlessWork("thirdWork");
        queue.add(thirdWork);
        HarmlessWork fourthWork = new HarmlessWork("fourthWork");
        queue.add(fourthWork);
        indexManager.performOperations(queue, null);
        Assert.assertEquals((int)4, (int)WORK_COUNTER.get());
        String errorMessage = mockErrorHandler.getErrorMessage();
        Throwable exception = mockErrorHandler.getLastException();
        StringBuilder expectedErrorMessage = new StringBuilder();
        expectedErrorMessage.append("Exception occurred ").append(exception).append("\n");
        expectedErrorMessage.append("Primary Failure:\n");
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)firstFailure);
        expectedErrorMessage.append("Subsequent failures:\n");
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)firstFailure);
        Assert.assertEquals((String)expectedErrorMessage.toString(), (String)errorMessage);
        Assert.assertTrue((boolean)(exception instanceof SearchException));
        Assert.assertEquals((String)"failed work message", (String)exception.getMessage());
    }

    private MockErrorHandler getErrorHandlerAndAssertCorrectTypeIsUsed() {
        SearchFactoryImplementor searchFactory = this.getSearchFactoryImpl();
        ErrorHandler errorHandler = searchFactory.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        return (MockErrorHandler)errorHandler;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Foo.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }

    static class FailingLuceneWorkDelegate
    implements LuceneWorkDelegate {
        FailingLuceneWorkDelegate() {
        }

        public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
        }

        public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
            throw new SearchException("failed work message");
        }
    }

    static class FailingWork
    extends DeleteLuceneWork {
        public FailingWork(String workIdentifier) {
            super((Serializable)((Object)workIdentifier), workIdentifier, Foo.class);
        }

        public <T> T getWorkDelegate(WorkVisitor<T> visitor) {
            if (visitor instanceof StreamingSelectionVisitor) {
                return (T)visitor.getDelegate((DeleteLuceneWork)this);
            }
            return (T)new FailingLuceneWorkDelegate();
        }

        public String toString() {
            return "FailingWork: " + this.getIdInString();
        }
    }

    static class NoOpLuceneWorkDelegate
    implements LuceneWorkDelegate {
        NoOpLuceneWorkDelegate() {
        }

        public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
        }

        public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
            WORK_COUNTER.incrementAndGet();
        }
    }

    static class HarmlessWork
    extends DeleteLuceneWork {
        public HarmlessWork(String workIdentifier) {
            super((Serializable)((Object)workIdentifier), workIdentifier, Foo.class);
        }

        public <T> T getWorkDelegate(WorkVisitor<T> visitor) {
            if (visitor instanceof StreamingSelectionVisitor) {
                return (T)visitor.getDelegate((DeleteLuceneWork)this);
            }
            return (T)new NoOpLuceneWorkDelegate();
        }

        public String toString() {
            return "HarmlessWork: " + this.getIdInString();
        }
    }
}

