/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import javax.persistence.EntityManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.test.SerializationTestHelper;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.jpa.Bretzel;
import org.hibernate.search.test.jpa.JPATestCase;
import org.junit.Assert;

public class EntityManagerSerializationTest
extends JPATestCase {
    public void testSerialization() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        EntityManagerSerializationTest.indexSearchAssert(em);
        FullTextEntityManager clone = SerializationTestHelper.duplicateBySerialization(em);
        EntityManagerSerializationTest.indexSearchAssert(clone);
        clone.close();
        em.close();
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Bretzel.class};
    }

    private static void indexSearchAssert(FullTextEntityManager em) throws Exception {
        em.getTransaction().begin();
        Bretzel bretzel = new Bretzel(23.0f, 34.0f);
        em.persist((Object)bretzel);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("saltQty:noword");
        Assert.assertEquals((long)0L, (long)em.createFullTextQuery(query, new Class[0]).getResultList().size());
        query = new TermQuery(new Term("saltQty", "23.0"));
        Assert.assertEquals((String)"getResultList", (long)1L, (long)em.createFullTextQuery(query, new Class[0]).getResultList().size());
        Assert.assertEquals((String)"getSingleResult and object retrieval", (double)23.0, (double)((Bretzel)em.createFullTextQuery(query, new Class[0]).getSingleResult()).getSaltQty());
        Assert.assertEquals((long)1L, (long)em.createFullTextQuery(query, new Class[0]).getResultSize());
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.remove(em.find(Bretzel.class, (Object)bretzel.getId()));
        em.getTransaction().commit();
    }
}

