/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.h2.Driver;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.batchindexing.Clock;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.testing.RequiresDialect;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@RequiresDialect(comment="The connection provider for this test requires H2", strictMatching=true, value={H2Dialect.class})
public class DatabaseMultitenancyTest
extends SearchTestBase {
    public static final Dialect DIALECT = new H2Dialect();
    private static final String METAMEC_TID = "metamec";
    private static final String GEOCHRON_TID = "geochron";
    private static String[] METAMEC_MODELS = new String[]{"Metamec - Model A850", "Metamec - Model 4562"};
    private static String[] GEOCHRON_MODELS = new String[]{"Geochron - Model The Original Kilburg", "Geochron - Model The Boardroom"};

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.multiTenancy", MultiTenancyStrategy.DATABASE.name());
        cfg.setProperty("hibernate.multi_tenant_connection_provider", ClockMultitenantConnectionProvider.class.getName());
        cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        cfg.getProperties().remove("hibernate.hbm2ddl.auto");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.exportSchema(ClockMultitenantConnectionProvider.GEOCHRON_PROVIDER, this.getCfg());
        this.exportSchema(ClockMultitenantConnectionProvider.METAMEC_PROVIDER, this.getCfg());
        Session sessionMetamec = this.openSessionWithTenantId(METAMEC_TID);
        this.persist(sessionMetamec, METAMEC_MODELS);
        sessionMetamec.close();
        Session sessionGeochron = this.openSessionWithTenantId(GEOCHRON_TID);
        this.persist(sessionGeochron, GEOCHRON_MODELS);
        sessionGeochron.close();
    }

    @Test
    public void shouldOnlyFindMetamecModels() throws Exception {
        List<Clock> list = this.searchAll(METAMEC_TID);
        Assertions.assertThat(list).onProperty("brand").containsOnly((Object[])METAMEC_MODELS);
    }

    @Test
    public void shouldOnlyFindGeochronModels() throws Exception {
        List<Clock> list = this.searchAll(GEOCHRON_TID);
        Assertions.assertThat(list).onProperty("brand").containsOnly((Object[])GEOCHRON_MODELS);
    }

    @Test
    public void shouldBePossibleToRunAQuery() throws Exception {
        List<Clock> list = this.searchModel("model", GEOCHRON_TID);
        Assertions.assertThat(list).onProperty("brand").containsOnly((Object[])GEOCHRON_MODELS);
    }

    @Test
    public void shouldBeAbleToPurgeTheIndex() {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        List<Clock> list = this.searchAll(GEOCHRON_TID);
        Assertions.assertThat(list).isEmpty();
    }

    @Test
    public void shouldBeAbleToRebuildTheIndexForTheTenantId() throws Exception {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        this.purgeAll(Clock.class, METAMEC_TID);
        this.rebuildIndexWithMassIndexer(Clock.class, GEOCHRON_TID);
        List<Clock> list = this.searchAll(GEOCHRON_TID);
        Assertions.assertThat(list).onProperty("brand").containsOnly((Object[])GEOCHRON_MODELS);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1792")
    @Ignore
    public void shouldOnlyPurgeTheEntitiesOfTheSelecedTenant() {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        List<Clock> list = this.searchAll(METAMEC_TID);
        Assertions.assertThat(list).onProperty("brand").containsOnly((Object[])METAMEC_MODELS);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1792")
    @Ignore
    public void shouldOnlyReturnResultsOfTheSpecificTenant() throws Exception {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        this.purgeAll(Clock.class, METAMEC_TID);
        this.rebuildIndexWithMassIndexer(Clock.class, GEOCHRON_TID);
        List<Clock> list = this.searchAll(METAMEC_TID);
        Assertions.assertThat(list).isEmpty();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1792")
    @Ignore
    public void shouldSearchOtherTenantsDocuments() throws Exception {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        this.purgeAll(Clock.class, METAMEC_TID);
        this.rebuildIndexWithMassIndexer(Clock.class, GEOCHRON_TID);
        List<Clock> list = this.searchModel(GEOCHRON_TID, METAMEC_TID);
        Assertions.assertThat(list).isEmpty();
    }

    private List<Clock> searchModel(String searchString, String tenantId) {
        FullTextSession session = Search.getFullTextSession((Session)this.openSessionWithTenantId(tenantId));
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query luceneQuery = queryBuilder.keyword().wildcard().onField("brand").matching((Object)searchString).createQuery();
        Transaction transaction = session.beginTransaction();
        List list = session.createFullTextQuery(luceneQuery, new Class[0]).list();
        transaction.commit();
        session.clear();
        session.close();
        return list;
    }

    private List<Clock> searchAll(String tenantId) {
        FullTextSession session = Search.getFullTextSession((Session)this.openSessionWithTenantId(tenantId));
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query luceneQuery = queryBuilder.all().createQuery();
        Transaction transaction = session.beginTransaction();
        List list = session.createFullTextQuery(luceneQuery, new Class[0]).list();
        transaction.commit();
        session.clear();
        session.close();
        return list;
    }

    private void rebuildIndexWithMassIndexer(Class<?> entityType, String tenantId) throws Exception {
        FullTextSession session = Search.getFullTextSession((Session)this.openSessionWithTenantId(tenantId));
        session.createIndexer(new Class[]{entityType}).purgeAllOnStart(true).startAndWait();
        int numDocs = session.getSearchFactory().getIndexReaderAccessor().open(new Class[]{entityType}).numDocs();
        session.close();
        Assertions.assertThat((int)numDocs).isGreaterThan(0);
    }

    private void purgeAll(Class<?> entityType, String tenantId) {
        FullTextSession session = Search.getFullTextSession((Session)this.openSessionWithTenantId(tenantId));
        session.purgeAll(entityType);
        session.flushToIndexes();
        int numDocs = session.getSearchFactory().getIndexReaderAccessor().open(new Class[]{entityType}).numDocs();
        session.close();
        Assertions.assertThat((int)numDocs).isEqualTo(0);
    }

    private Session openSessionWithTenantId(String tenantId) {
        return this.getSessionFactory().withOptions().tenantIdentifier(tenantId).openSession();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    private void persist(Session session, String ... models) {
        session.beginTransaction();
        for (int i = 0; i < models.length; ++i) {
            session.persist((Object)new Clock(i + 1, models[i]));
        }
        session.getTransaction().commit();
        session.clear();
    }

    @After
    public void deleteEntities() throws Exception {
        Session session = this.openSessionWithTenantId(METAMEC_TID);
        this.deleteClocks(session);
        session.close();
        session = this.openSessionWithTenantId(GEOCHRON_TID);
        this.deleteClocks(session);
        session.close();
    }

    private void deleteClocks(Session session) {
        session.beginTransaction();
        List clocks = session.createCriteria(Clock.class).list();
        for (Clock clock : clocks) {
            session.delete((Object)clock);
        }
        session.getTransaction().commit();
        session.clear();
    }

    private void exportSchema(final ConnectionProvider provider, Configuration cfg) {
        String[] generateDropSchemaScript = cfg.generateDropSchemaScript(DIALECT);
        String[] generateSchemaCreationScript = cfg.generateSchemaCreationScript(DIALECT);
        new SchemaExport(new ConnectionHelper(){
            private Connection connection;

            public void prepare(boolean needsAutoCommit) throws SQLException {
                this.connection = provider.getConnection();
            }

            public Connection getConnection() throws SQLException {
                return this.connection;
            }

            public void release() throws SQLException {
                provider.closeConnection(this.connection);
            }
        }, generateDropSchemaScript, generateSchemaCreationScript).execute(false, true, false, false);
    }

    public static class ClockMultitenantConnectionProvider
    extends AbstractMultiTenantConnectionProvider {
        private static final ConnectionProvider METAMEC_PROVIDER = ClockMultitenantConnectionProvider.buildConnectionProvider("metamec");
        private static final ConnectionProvider GEOCHRON_PROVIDER = ClockMultitenantConnectionProvider.buildConnectionProvider("geochron");

        protected ConnectionProvider getAnyConnectionProvider() {
            return GEOCHRON_PROVIDER;
        }

        protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
            if (DatabaseMultitenancyTest.METAMEC_TID.equals(tenantIdentifier)) {
                return METAMEC_PROVIDER;
            }
            if (DatabaseMultitenancyTest.GEOCHRON_TID.equals(tenantIdentifier)) {
                return GEOCHRON_PROVIDER;
            }
            throw new HibernateException("Unknown tenant identifier: " + tenantIdentifier);
        }

        private static DriverManagerConnectionProviderImpl buildConnectionProvider(String tenantId) {
            DriverManagerConnectionProviderImpl connectionProvider = new DriverManagerConnectionProviderImpl();
            connectionProvider.configure((Map)ClockMultitenantConnectionProvider.getConnectionProviderProperties(tenantId + "-db"));
            return connectionProvider;
        }

        public static Properties getConnectionProviderProperties(String dbName) {
            Properties props = new Properties(null);
            props.put("hibernate.connection.driver_class", Driver.class.getName());
            props.put("hibernate.connection.url", String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;MVCC=TRUE", dbName));
            props.put("hibernate.connection.username", "sa");
            props.put("hibernate.connection.password", "");
            return props;
        }
    }
}

