/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.batchindexing.LegacyCar;
import org.hibernate.search.test.batchindexing.LegacyCarPlant;
import org.hibernate.search.test.batchindexing.LegacyTire;
import org.hibernate.search.test.util.progessmonitor.AssertingMassIndexerProgressMonitor;
import org.junit.Before;
import org.junit.Test;

public class ProgressMonitorTest
extends SearchTestBase {
    FullTextSession fullTextSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        ProgressMonitorTest.initializeData(this.fullTextSession);
    }

    @Test
    public void testAllRelevantProgressMonitoringOperationsCalled() throws InterruptedException {
        AssertingMassIndexerProgressMonitor monitor = new AssertingMassIndexerProgressMonitor(10, 10);
        this.fullTextSession.createIndexer(new Class[]{LegacyCar.class}).progressMonitor((MassIndexerProgressMonitor)monitor).startAndWait();
        this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{LegacyCar.class}).getResultSize();
        monitor.assertExpectedProgressMade();
    }

    private static void initializeData(FullTextSession fullTextSession) {
        Transaction transaction = fullTextSession.beginTransaction();
        LegacyCar[] cars = new LegacyCar[10];
        for (int i = 0; i < cars.length; ++i) {
            cars[i] = new LegacyCar();
            cars[i].setId("" + i);
            cars[i].setModel("model" + i);
            fullTextSession.persist((Object)cars[i]);
        }
        transaction.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{LegacyCarPlant.class, LegacyCar.class, LegacyTire.class};
    }
}

