/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.integration;

import java.util.Map;
import java.util.Properties;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.util.ServiceRegistryTools;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class HibernateSearchSessionFactoryObserverTest {
    @Test
    @Ignore
    @BMRules(rules={@BMRule(targetClass="org.hibernate.internal.SessionFactoryImpl", targetMethod="close", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="Session close counter"), @BMRule(targetClass="org.hibernate.search.spi.SearchFactoryBuilder", targetMethod="buildSearchFactory", action="throw new java.lang.RuntimeException(\"Byteman created runtime exception\")", name="Factory build prohibitor")})
    public void testSessionFactoryGetsClosedOnSearchFactoryCreationFailure() {
        Configuration hibernateConfiguration = new Configuration();
        hibernateConfiguration.addAnnotatedClass(Foo.class);
        Properties properties = new Properties();
        properties.setProperty("hibernate.search.default.directory_provider", "ram");
        hibernateConfiguration.getProperties().putAll((Map<?, ?>)properties);
        ServiceRegistryBuilder registryBuilder = new ServiceRegistryBuilder();
        registryBuilder.applySettings((Map)hibernateConfiguration.getProperties());
        ServiceRegistry serviceRegistry = ServiceRegistryTools.build(registryBuilder);
        try {
            hibernateConfiguration.buildSessionFactory(serviceRegistry);
            Assert.fail((String)"ByteMan should have forced an exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Wrong invocation count", (long)1L, (long)BytemanHelper.getAndResetInvocationCount());
        }
    }

    @Entity
    @Indexed
    public static class Foo {
        @Id
        private long id;
    }
}

