/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.math.BigDecimal;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.Country;
import org.hibernate.search.test.engine.Location;
import org.hibernate.search.test.engine.PinPoint;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumericFieldTest
extends SearchTestBase {
    FullTextSession fullTextSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.cleanData();
        Assert.assertTrue((boolean)this.indexIsEmpty());
        super.tearDown();
    }

    @Test
    public void testIndexAndSearchNumericField() {
        Transaction tx = this.fullTextSession.beginTransaction();
        Assert.assertEquals((String)"Query id ", (long)3L, (long)this.numericQueryFor("overriddenFieldName", 1, 3).size());
        Assert.assertEquals((String)"Query by double range", (long)3L, (long)this.numericQueryFor("latitude", -10.0, 10.0).size());
        Assert.assertEquals((String)"Query by integer range", (long)4L, (long)this.numericQueryFor("ranking", 1, 2).size());
        Assert.assertEquals((String)"Query by long range", (long)3L, (long)this.numericQueryFor("myCounter", 1L, 3L).size());
        Assert.assertEquals((String)"Query by multi-fields", (long)2L, (long)this.numericQueryFor("strMultiple", 0.7, 0.9).size());
        Assert.assertEquals((String)"Query on custom bridge by range", (long)4L, (long)this.numericQueryFor("visibleStars", -100L, 500L).size());
        Assert.assertEquals((String)"Query by id excluding upper", (long)2L, (long)this.numericQueryFor("overriddenFieldName", 1, 3, true, false).size());
        Assert.assertEquals((String)"Query by id excluding upper and lower", (long)1L, (long)this.numericQueryFor("overriddenFieldName", 1, 3, false, false).size());
        Assert.assertEquals((String)"Range Query for indexed embedded", (long)2L, (long)this.numericQueryFor("country.idh", 0.9, 1.0).size());
        Assert.assertEquals((String)"Range Query across entities", (long)1L, (long)this.numericQueryFor("pinPoints.stars", 4, 5).size());
        Assert.assertEquals((String)"Query id exact", (long)1L, (long)this.doExactQuery("overriddenFieldName", 1).getId());
        Assert.assertEquals((String)"Query double exact", (long)2L, (long)this.doExactQuery("latitude", -10.0).getId());
        Assert.assertEquals((String)"Query integer exact", (long)3L, (long)this.doExactQuery("longitude", -20.0).getId());
        Assert.assertEquals((String)"Query long exact", (long)4L, (long)this.doExactQuery("myCounter", 4L).getId());
        Assert.assertEquals((String)"Query multifield exact", (long)5L, (long)this.doExactQuery("strMultiple", 0.1).getId());
        Assert.assertEquals((String)"Query on custom bridge exact", (long)3L, (long)this.doExactQuery("visibleStars", 1000L).getId());
        tx.commit();
        this.fullTextSession.clear();
        tx = this.fullTextSession.beginTransaction();
        List allLocations = this.fullTextSession.createCriteria(Location.class).list();
        for (Object location : allLocations) {
            this.fullTextSession.delete(location);
        }
        tx.commit();
        this.fullTextSession.clear();
        tx = this.fullTextSession.beginTransaction();
        Assert.assertEquals((String)"Check for deletion on Query", (long)0L, (long)this.numericQueryFor("overriddenFieldName", 1, 6).size());
        Query query = NumericFieldUtils.createNumericRangeQuery((String)"overriddenFieldName", (Object)1, (Object)6, (boolean)true, (boolean)true);
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Location.class}).setProjection(new String[]{"__HSearch_Document"});
        Assert.assertEquals((String)"Check for deletion on index projection", (long)0L, (long)fullTextQuery.list().size());
        tx.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestForIssue(jiraKey="HSEARCH-1193")
    @Test
    public void testNumericFieldProjections() {
        Transaction tx = this.fullTextSession.beginTransaction();
        try {
            Query latitudeQuery = NumericFieldUtils.createNumericRangeQuery((String)"latitude", (Object)-20.0, (Object)-20.0, (boolean)true, (boolean)true);
            List list = this.fullTextSession.createFullTextQuery(latitudeQuery, new Class[]{Location.class}).setProjection(new String[]{"latitude"}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Object[] firstProjection = (Object[])list.get(0);
            Assert.assertEquals((long)1L, (long)firstProjection.length);
            Assert.assertEquals((Object)-20.0, (Object)firstProjection[0]);
            List listAgain = this.fullTextSession.createFullTextQuery(latitudeQuery, new Class[]{Location.class}).setProjection(new String[]{"coordinatePair_x", "coordinatePair_y"}).list();
            Assert.assertEquals((long)1L, (long)listAgain.size());
            Object[] secondProjection = (Object[])listAgain.get(0);
            Assert.assertEquals((long)2L, (long)secondProjection.length);
            Assert.assertEquals((Object)1.0, (Object)secondProjection[0]);
            Assert.assertEquals((Object)2.0, (Object)secondProjection[1]);
        }
        finally {
            tx.commit();
        }
    }

    private boolean indexIsEmpty() {
        int numDocsLocation = this.countSizeForType(Location.class);
        int numDocsPinPoint = this.countSizeForType(PinPoint.class);
        return numDocsLocation == 0 && numDocsPinPoint == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countSizeForType(Class<?> type) {
        SearchFactory searchFactory = this.fullTextSession.getSearchFactory();
        int numDocs = -1;
        IndexReader locationIndexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{type});
        try {
            numDocs = locationIndexReader.numDocs();
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(locationIndexReader);
        }
        return numDocs;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{PinPoint.class, Location.class};
    }

    private Location doExactQuery(String fieldName, Object value) {
        Query matchQuery = NumericFieldUtils.createExactMatchQuery((String)fieldName, (Object)value);
        return (Location)this.fullTextSession.createFullTextQuery(matchQuery, new Class[]{Location.class}).list().get(0);
    }

    private List numericQueryFor(String fieldName, Object from, Object to) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{Location.class}).list();
    }

    private List numericQueryFor(String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)includeLower, (boolean)includeUpper);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{Location.class}).list();
    }

    private void prepareData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        Location loc1 = new Location(1, 1L, -20.0, -40.0, 1, "Random text", 1.5, this.countryFor("England", 0.947), BigDecimal.ONE);
        loc1.addPinPoints(new PinPoint(1, 4, loc1), new PinPoint(2, 5, loc1));
        Location loc2 = new Location(2, 2L, -10.0, -30.0, 1, "Some text", 0.786, this.countryFor("Italy", 0.951), BigDecimal.ONE);
        loc2.addPinPoints(new PinPoint(3, 1, loc2), new PinPoint(4, 2, loc2));
        Location loc3 = new Location(3, 3L, 0.0, -20.0, 1, "A text", 0.86, this.countryFor("Brazil", 0.813), BigDecimal.TEN);
        Location loc4 = new Location(4, 4L, 10.0, 0.0, 2, "Any text", 0.99, this.countryFor("France", 0.872), BigDecimal.ONE);
        Location loc5 = new Location(5, 5L, 20.0, 20.0, 3, "Random text", 0.1, this.countryFor("India", 0.612), BigDecimal.ONE);
        this.fullTextSession.save((Object)loc1);
        this.fullTextSession.save((Object)loc2);
        this.fullTextSession.save((Object)loc3);
        this.fullTextSession.save((Object)loc4);
        this.fullTextSession.save((Object)loc5);
        tx.commit();
        this.fullTextSession.clear();
    }

    private Country countryFor(String name, double idh) {
        return new Country(name, idh);
    }

    private void cleanData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        List locations = this.fullTextSession.createCriteria(Location.class).list();
        for (Location location : locations) {
            this.fullTextSession.delete((Object)location);
        }
        tx.commit();
        this.fullTextSession.close();
    }
}

