/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.util.Calendar;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.filter.Driver;
import org.hibernate.search.test.filter.InstanceBasedExcludeAllFilter;
import org.hibernate.search.test.filter.Soap;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterTest
extends SearchTestBase {
    private BooleanQuery query;
    private FullTextSession fullTextSession;

    @Test
    public void testNamedFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        Assert.assertEquals((String)"No filter should happen", (long)3L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.disableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("bestDriver");
        Assert.assertEquals((String)"Should filter out Gavin", (long)2L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        Assert.assertEquals((String)"Should filter to limit to Emmanuel", (long)1L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        ftQuery.disableFullTextFilter("security");
        ftQuery.disableFullTextFilter("bestDriver");
        Assert.assertEquals((String)"Should not filter anymore", (long)3L, (long)ftQuery.getResultSize());
    }

    @Test
    public void testCache() {
        InstanceBasedExcludeAllFilter.assertConstructorInvoked(1);
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        Assert.assertEquals((String)"No filter should happen", (long)3L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheresultstest");
        Assert.assertEquals((String)"Should filter out all", (long)0L, (long)ftQuery.getResultSize());
        System.gc();
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheresultstest");
        try {
            ftQuery.getResultSize();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Cache results does not work");
        }
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancetest");
        InstanceBasedExcludeAllFilter.assertConstructorInvoked(1);
        Assert.assertEquals((String)"Should filter out all", (long)0L, (long)ftQuery.getResultSize());
        InstanceBasedExcludeAllFilter.assertConstructorInvoked(2);
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancetest");
        ftQuery.getResultSize();
    }

    @Test
    public void testStraightFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2001);
        long from = DateTools.round((long)calendar.getTime().getTime(), (DateTools.Resolution)DateTools.Resolution.YEAR);
        calendar.set(1, 2005);
        long to = DateTools.round((long)calendar.getTime().getTime(), (DateTools.Resolution)DateTools.Resolution.YEAR);
        NumericRangeFilter dateFilter = NumericRangeFilter.newLongRange((String)"delivery", (Long)from, (Long)to, (boolean)true, (boolean)true);
        ftQuery.setFilter((Filter)dateFilter);
        Assert.assertEquals((String)"Should select only liz", (long)1L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("empty");
        Assert.assertEquals((String)"two filters, one is empty, should not match anything", (long)0L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.setFilter((Filter)dateFilter);
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        ftQuery.disableFullTextFilter("security");
        ftQuery.disableFullTextFilter("bestDriver");
        ftQuery.setFilter(null);
        Assert.assertEquals((String)"Should not filter anymore", (long)3L, (long)ftQuery.getResultSize());
    }

    @TestForIssue(jiraKey="HSEARCH-1513")
    @Test
    public void testCachedEmptyFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2001);
        long from = DateTools.round((long)calendar.getTime().getTime(), (DateTools.Resolution)DateTools.Resolution.YEAR);
        calendar.set(1, 2005);
        long to = DateTools.round((long)calendar.getTime().getTime(), (DateTools.Resolution)DateTools.Resolution.YEAR);
        NumericRangeFilter dateFilter = NumericRangeFilter.newLongRange((String)"delivery", (Long)from, (Long)to, (boolean)true, (boolean)true);
        ftQuery.setFilter((Filter)dateFilter);
        Assert.assertEquals((String)"Should select only liz", (long)1L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("cached_empty");
        Assert.assertEquals((String)"two filters, one is empty, should not match anything", (long)0L, (long)ftQuery.getResultSize());
    }

    @Test
    public void testMultipleFiltersOfSameTypeWithDifferentParameters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("fieldConstraintFilter-1").setParameter("field", (Object)"teacher").setParameter("value", (Object)"andre");
        ftQuery.enableFullTextFilter("fieldConstraintFilter-2").setParameter("field", (Object)"teacher").setParameter("value", (Object)"aaron");
        Assert.assertEquals((String)"Should apply both filters resulting in 0 results", (long)0L, (long)ftQuery.getResultSize());
    }

    @Test
    public void testUnknownFilterNameThrowsException() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        try {
            ftQuery.enableFullTextFilter("foo");
            Assert.fail((String)"Retrieving an unknown filter should throw a SearchException");
        }
        catch (SearchException e) {
            Assert.assertEquals((String)"Wrong message", (Object)"HSEARCH000115: Unknown @FullTextFilter: 'foo'", (Object)e.getMessage());
        }
    }

    private void createData() {
        Session s = this.openSession();
        s.getTransaction().begin();
        Calendar cal = Calendar.getInstance();
        cal.set(2006, 10, 11);
        Driver driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(1);
        driver.setName("Emmanuel");
        driver.setScore(5);
        driver.setTeacher("andre");
        s.persist((Object)driver);
        cal.set(2007, 10, 11);
        driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(2);
        driver.setName("Gavin");
        driver.setScore(3);
        driver.setTeacher("aaron");
        s.persist((Object)driver);
        cal.set(2004, 10, 11);
        driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(3);
        driver.setName("Liz");
        driver.setScore(5);
        driver.setTeacher("max");
        s.persist((Object)driver);
        s.getTransaction().commit();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createData();
        this.query = this.createQuery();
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.fullTextSession.getTransaction().begin();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fullTextSession.getTransaction().commit();
        this.fullTextSession.close();
        super.tearDown();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Driver.class, Soap.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.filter.cache_docidresults.size", "10");
        InstanceBasedExcludeAllFilter.reset();
    }

    private BooleanQuery createQuery() {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("teacher", "andre")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "max")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "aaron")), BooleanClause.Occur.SHOULD);
        return query;
    }
}

