/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.test.query.facet.Fruit;
import org.junit.Assert;
import org.junit.Test;

public class NoQueryResultsFacetingTest
extends AbstractFacetTest {
    private final String facetName = "ccs";

    @Test
    public void testSimpleDiscretFacetingWithNoResultsQuery() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity_string_facet_string").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaNoResultsWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        Assert.assertEquals((String)"Wrong number of facets", (long)0L, (long)facetList.size());
    }

    @Test
    public void testMultipleFacetsWithNoResultsQuery() {
        String descendingOrderedFacet = "desc";
        FacetingRequest requestDesc = this.queryBuilder(Car.class).facet().name("desc").onField("cubicCapacity_string_facet_string").discrete().includeZeroCounts(true).createFacetingRequest();
        String ascendingOrderedFacet = "asc";
        FacetingRequest requestAsc = this.queryBuilder(Car.class).facet().name("asc").onField("cubicCapacity_string_facet_string").discrete().orderedBy(FacetSortOrder.COUNT_ASC).includeZeroCounts(true).createFacetingRequest();
        TermQuery term = new TermQuery(new Term("make", "nonExistentValue"));
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)term, new Class[]{Car.class});
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(requestDesc);
        facetManager.enableFaceting(requestAsc);
        this.assertFacetCounts(facetManager.getFacets("desc"), new int[]{0, 0, 0, 0});
        this.assertFacetCounts(facetManager.getFacets("asc"), new int[]{0, 0, 0, 0});
        facetManager.disableFaceting("desc");
        Assert.assertTrue((String)"descendingOrderedFacet should be disabled", (boolean)query.getFacetManager().getFacets("desc").isEmpty());
        this.assertFacetCounts(facetManager.getFacets("asc"), new int[]{0, 0, 0, 0});
        facetManager.disableFaceting("asc");
        Assert.assertTrue((String)"descendingOrderedFacet should be disabled", (boolean)facetManager.getFacets("desc").isEmpty());
        Assert.assertTrue((String)"ascendingOrderedFacet should be disabled", (boolean)facetManager.getFacets("asc").isEmpty());
    }

    private FullTextQuery queryHondaNoResultsWithFacet(FacetingRequest request) {
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"nonExistentValue").createQuery();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        query.getFacetManager().enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of query matches", (long)0L, (long)query.getResultSize());
        return query;
    }

    @Test
    public void testSimpleDiscretFacetingQuery() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity_string_facet_string").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        Assert.assertEquals((String)"Wrong number of facets", (long)3L, (long)facetList.size());
    }

    @Test
    public void testMultipleFacetsQuery() {
        String descendingOrderedFacet = "desc";
        FacetingRequest requestDesc = this.queryBuilder(Car.class).facet().name("desc").onField("cubicCapacity_string_facet_string").discrete().includeZeroCounts(true).createFacetingRequest();
        String ascendingOrderedFacet = "asc";
        FacetingRequest requestAsc = this.queryBuilder(Car.class).facet().name("asc").onField("cubicCapacity_string_facet_string").discrete().orderedBy(FacetSortOrder.COUNT_ASC).includeZeroCounts(true).createFacetingRequest();
        TermQuery term = new TermQuery(new Term("make", "Honda"));
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)term, new Class[]{Car.class});
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(requestDesc);
        facetManager.enableFaceting(requestAsc);
        this.assertFacetCounts(facetManager.getFacets("desc"), new int[]{5, 4, 4, 0});
        this.assertFacetCounts(facetManager.getFacets("asc"), new int[]{0, 4, 4, 5});
        facetManager.disableFaceting("desc");
        Assert.assertTrue((String)"descendingOrderedFacet should be disabled", (boolean)query.getFacetManager().getFacets("desc").isEmpty());
        this.assertFacetCounts(facetManager.getFacets("asc"), new int[]{0, 4, 4, 5});
        facetManager.disableFaceting("asc");
        Assert.assertTrue((String)"descendingOrderedFacet should be disabled", (boolean)facetManager.getFacets("desc").isEmpty());
        Assert.assertTrue((String)"ascendingOrderedFacet should be disabled", (boolean)facetManager.getFacets("asc").isEmpty());
    }

    private FullTextQuery queryHondaWithFacet(FacetingRequest request) {
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"Honda").createQuery();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        query.getFacetManager().enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of query matches", (long)13L, (long)query.getResultSize());
        return query;
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                }
            }
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        Fruit apple = new Fruit("Apple", 3.15);
        session.save((Object)apple);
        tx.commit();
        session.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class, Fruit.class};
    }
}

