/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.jmx.SimpleJNDIHelper;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-4336")
public class JMXDeprecationTest
extends SearchInitializationTestBase {
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();

    @Test
    public void default_warning() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        this.enableJmx(settings);
        this.logged.expectEvent(Level.WARN, CoreMatchers.nullValue(), "Enabling JMX", new String[]{"Support for statistics retrieved through JMX and indexing triggered through JMX is going to be removed in Hibernate Search 6"});
        this.init(new ImmutableTestConfiguration(settings, new Class[]{IndexedEntityType.class}));
    }

    @Test
    public void property_noWarning() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        this.enableJmx(settings);
        settings.put("hibernate.search.v6_migration.deprecation_warnings", "false");
        this.logged.expectEvent(Level.WARN, CoreMatchers.anything(), "JMX", new String[0]).never();
        this.init(new ImmutableTestConfiguration(settings, new Class[]{IndexedEntityType.class}));
    }

    private void enableJmx(Map<String, Object> settings) {
        Path simpleJndiDir = SimpleJNDIHelper.makeTestingJndiDirectory(JMXDeprecationTest.class);
        SimpleJNDIHelper.enableSimpleJndi(settings, (Path)simpleJndiDir);
        settings.put("hibernate.session_factory_name", "java:comp/SessionFactory");
        settings.put("hibernate.search.jmx_enabled", "true");
    }

    @Indexed(index="myIndex")
    public static class IndexedEntityType {
        @DocumentId
        private long id;
        @Field
        private String field;
    }
}

