/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.Person;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class QueryUnindexedEntityTest
extends SearchTestBase {
    @Test
    public void testQueryOnAllEntities() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Person person = new Person();
        person.setName("Jon Doe");
        s.save((Object)person);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("name", TestConstants.standardAnalyzer);
        Query query = parser.parse("name:foo");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[0]);
        try {
            hibQuery.list();
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Wrong message", (boolean)e.getMessage().contains("Cannot query: there aren't any mapped entity"));
        }
        tx.rollback();
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class};
    }
}

