/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractFacetTest
extends SearchTestBase {
    public static final String[] colors = new String[]{"red", "black", "white", "blue"};
    public static final String[] makes = new String[]{"Honda", "Toyota", "BMW", "Mercedes"};
    public static final int[] ccs = new int[]{3398, 2407, 2831};
    public static final String[] albums = new String[]{"A boy named Johnny", "A boy named Sue", "A thing called love", "Adventures od Johnny Cash", "American Outlaw", "At Folsom Prison", "Any old wind that blows", "Unearthed", "The man comes around", "Water from the Wells of Home"};
    public static final int[] albumPrices = new int[]{499, 999, 1500, 1500, 1500, 1600, 1700, 1800, 2000, 2500};
    public static final String[] releaseDates = new String[]{"2001", "2002", "1972", "1982", "2010", "1968", "1973", "2003", "2002", "1988"};
    public static final String[] fruits = new String[]{"apple", "pear", "banana", "kiwi", "orange", "papaya", "grape", "mango", "mandarin", "pineapple"};
    public static final double[] fruitPrices = new double[]{0.5, 0.99, 1.5, 1.5, 1.5, 1.6, 1.7, 1.8, 2.0, 2.5};
    public static final Integer[] horsePowers = new Integer[]{200, 400, 600, 1300, 730};
    protected FullTextSession fullTextSession;
    protected Transaction tx;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.loadTestData((Session)this.fullTextSession);
        this.tx = this.fullTextSession.beginTransaction();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.tx.commit();
        this.fullTextSession.clear();
        this.fullTextSession.close();
        super.tearDown();
    }

    public FullTextQuery createMatchAllQuery(Class<?> clazz) {
        QueryBuilder builder = this.queryBuilder(clazz);
        Query luceneQuery = builder.all().createQuery();
        return this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{clazz});
    }

    public QueryBuilder queryBuilder(Class<?> clazz) {
        return this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(clazz).get();
    }

    public void assertFacetCounts(List<Facet> facetList, int[] counts) {
        Assert.assertEquals((String)"Wrong number of facets", (long)counts.length, (long)facetList.size());
        for (int i = 0; i < facetList.size(); ++i) {
            Assert.assertEquals((String)("Wrong facet count for facet " + i), (long)counts[i], (long)facetList.get(i).getCount());
        }
    }

    public void assertFacetValues(List<Facet> facetList, Object[] values) {
        Assert.assertEquals((String)"Wrong number of facets", (long)values.length, (long)facetList.size());
        for (int i = 0; i < facetList.size(); ++i) {
            Assert.assertEquals((String)("Wrong facet value for facet " + i), (Object)values[i], (Object)facetList.get(i).getValue());
        }
    }

    public abstract void loadTestData(Session var1);
}

