/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.impl.IdHashShardingStrategy;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.shards.Animal;
import org.hibernate.search.test.shards.Furniture;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.indexmanager.RamIndexManagerFactory;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ShardsTest
extends SearchTestBase {
    @Rule
    public RamIndexManagerFactory managerFactory = new RamIndexManagerFactory();

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.directory_provider", "filesystem");
        Path sub = this.getBaseIndexDir();
        cfg.put("hibernate.search.default.indexBase", sub.toAbsolutePath().toString());
        cfg.put("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.put("hibernate.search.Animal.sharding_strategy.nbr_of_shards", "2");
        cfg.put("hibernate.search.Animal.0.indexName", "Animal00");
    }

    @Test
    public void testIdShardingStrategy() {
        IndexManager[] dps = this.managerFactory.createArray(2);
        IdHashShardingStrategy shardingStrategy = new IdHashShardingStrategy();
        shardingStrategy.initialize(null, dps);
        Assert.assertTrue((dps[1] == shardingStrategy.getIndexManagerForAddition(Animal.class, (Serializable)Integer.valueOf(1), "1", null) ? 1 : 0) != 0);
        Assert.assertTrue((dps[0] == shardingStrategy.getIndexManagerForAddition(Animal.class, (Serializable)Integer.valueOf(2), "2", null) ? 1 : 0) != 0);
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testBehavior() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Animal a = new Animal();
        a.setId(1);
        a.setName("Elephant");
        s.persist((Object)a);
        a = new Animal();
        a.setId(2);
        a.setName("Bear");
        s.persist((Object)a);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        a = (Animal)s.get(Animal.class, (Serializable)Integer.valueOf(1));
        a.setName("Mouse");
        Furniture fur = new Furniture();
        fur.setColor("dark blue");
        s.persist((Object)fur);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser("id", TestConstants.stopAnalyzer);
        List results = fts.createFullTextQuery(parser.parse("name:mouse OR name:bear"), new Class[0]).list();
        Assert.assertEquals((String)"Either double insert, single update, or query fails with shards", (long)2L, (long)results.size());
        results = fts.createFullTextQuery(parser.parse("name:mouse OR name:bear OR color:blue"), new Class[0]).list();
        Assert.assertEquals((String)"Mixing shared and non sharded properties fails", (long)3L, (long)results.size());
        results = fts.createFullTextQuery(parser.parse("name:mouse OR name:bear OR color:blue"), new Class[0]).list();
        Assert.assertEquals((String)"Mixing shared and non sharded properties fails with indexreader reuse", (long)3L, (long)results.size());
        for (Object o : results) {
            s.delete(o);
        }
        tx.commit();
        s.close();
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testInternalSharding() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Animal a = new Animal();
        a.setId(1);
        a.setName("Elephant");
        s.persist((Object)a);
        a = new Animal();
        a.setId(2);
        a.setName("Bear");
        s.persist((Object)a);
        tx.commit();
        s.clear();
        Assert.assertEquals((long)1L, (long)this.getNumberOfDocumentsInIndex("Animal00"));
        Assert.assertEquals((long)1L, (long)this.getNumberOfDocumentsInIndex("Animal.1"));
        tx = s.beginTransaction();
        a = (Animal)s.get(Animal.class, (Serializable)Integer.valueOf(1));
        a.setName("Mouse");
        tx.commit();
        s.clear();
        Assert.assertEquals((long)1L, (long)this.getNumberOfDocumentsInIndex("Animal.1"));
        Assert.assertEquals((long)1L, (long)this.getNumberOfDocumentsInIndexByQuery("Animal.1", "name", "mouse"));
        tx = s.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser("id", TestConstants.stopAnalyzer);
        List results = fts.createFullTextQuery(parser.parse("name:mouse OR name:bear"), new Class[0]).list();
        Assert.assertEquals((String)"Either double insert, single update, or query fails with shards", (long)2L, (long)results.size());
        for (Object o : results) {
            s.delete(o);
        }
        tx.commit();
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Animal.class, Furniture.class};
    }
}

