/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.ArrayBridgeNullEmbeddedTestEntity;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ElasticsearchSupportInProgress.class})
public class ArrayBridgeNullEmbeddedTest
extends SearchTestBase {
    private FullTextSession fullTextSession;
    private ArrayBridgeNullEmbeddedTestEntity withoutNull;
    private ArrayBridgeNullEmbeddedTestEntity withNullEntry;
    private ArrayBridgeNullEmbeddedTestEntity withNullEmbedded;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    private void prepareData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        this.withoutNull = this.persistEntity((Session)this.fullTextSession, "Davide D'Alto");
        this.withoutNull.setNullIndexed(new ArrayBridgeNullEmbeddedTestEntity.Language[]{ArrayBridgeNullEmbeddedTestEntity.Language.ITALIAN, ArrayBridgeNullEmbeddedTestEntity.Language.ENGLISH});
        this.withoutNull.setNumericNullIndexed(new Integer[]{1, 2});
        this.withNullEntry = this.persistEntity((Session)this.fullTextSession, "Worf");
        this.withNullEntry.setNullIndexed(new ArrayBridgeNullEmbeddedTestEntity.Language[]{ArrayBridgeNullEmbeddedTestEntity.Language.KLINGON, ArrayBridgeNullEmbeddedTestEntity.Language.ENGLISH, null});
        this.withNullEntry.setNumericNullIndexed(new Integer[]{11, null});
        this.withNullEmbedded = this.persistEntity((Session)this.fullTextSession, "Mime");
        this.withNullEmbedded.setNumericNullIndexed(null);
        this.withNullEmbedded.setNullIndexed(null);
        tx.commit();
    }

    @Test
    public void testSearchNullEntry() throws Exception {
        List<ArrayBridgeNullEmbeddedTestEntity> results = this.findResults("nullIndexed", "NULL_MARKER", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testSearchNullEmbedded() throws Exception {
        List<ArrayBridgeNullEmbeddedTestEntity> results = this.findEmbeddedNullResults("nullIndexed", "EMBEDDED_NULL", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection", (Object)this.withNullEmbedded.getName(), (Object)results.get(0).getName());
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testSearchNullNumericEmbedded() throws Exception {
        List<ArrayBridgeNullEmbeddedTestEntity> results = this.findEmbeddedNullResults("embeddedNum", "-666", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null collection", (Object)this.withNullEmbedded.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNullNumericEntry() throws Exception {
        List<ArrayBridgeNullEmbeddedTestEntity> results = this.findResults("numericNullIndexed", "-555", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullEntry() throws Exception {
        List<ArrayBridgeNullEmbeddedTestEntity> results = this.findResults("nullIndexed", (Object)ArrayBridgeNullEmbeddedTestEntity.Language.KLINGON, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)ArrayBridgeNullEmbeddedTestEntity.Language.ITALIAN, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)ArrayBridgeNullEmbeddedTestEntity.Language.ENGLISH, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)2L, (long)results.size());
    }

    @Test
    public void testSearchNotNullNumeric() throws Exception {
        List<ArrayBridgeNullEmbeddedTestEntity> results = this.findNumericResults("numericNullIndexed", 1);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findNumericResults("numericNullIndexed", 11);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    private List<ArrayBridgeNullEmbeddedTestEntity> findEmbeddedNullResults(String fieldName, Object value, boolean checkNullToken) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ArrayBridgeNullEmbeddedTestEntity.class).get();
        TermMatchingContext termMatchingContext = queryBuilder.keyword().onField(fieldName);
        if (checkNullToken) {
            termMatchingContext.ignoreFieldBridge();
        }
        Query query = ((TermMatchingContext)termMatchingContext.ignoreAnalyzer()).matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeNullEmbeddedTestEntity.class}).list();
    }

    private List<ArrayBridgeNullEmbeddedTestEntity> findResults(String fieldName, Object value, boolean checkNullToken) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ArrayBridgeNullEmbeddedTestEntity.class).get();
        TermMatchingContext termMatchingContext = queryBuilder.keyword().onField(fieldName);
        if (checkNullToken) {
            termMatchingContext.ignoreFieldBridge();
            termMatchingContext.ignoreAnalyzer();
        }
        Query query = termMatchingContext.matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeNullEmbeddedTestEntity.class}).list();
    }

    private List<ArrayBridgeNullEmbeddedTestEntity> findNumericResults(String fieldName, Object number) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)number, (Object)number, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeNullEmbeddedTestEntity.class}).list();
    }

    private ArrayBridgeNullEmbeddedTestEntity persistEntity(Session s, String name) {
        ArrayBridgeNullEmbeddedTestEntity boy = new ArrayBridgeNullEmbeddedTestEntity();
        boy.setName(name);
        s.persist((Object)boy);
        return boy;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ArrayBridgeNullEmbeddedTestEntity.class};
    }
}

