/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.integration;

import java.util.Collections;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.internal.EventListenerServiceInitiator;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.HibernateSearchIntegrator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.SessionFactoryServiceRegistryImpl;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiatorContext;
import org.junit.Assert;
import org.junit.Test;

public class DuplicationStrategyTest {
    @Test
    public void testMultipleRegistrationOfEventListenerKeepsOriginalListener() {
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().build();
        Metadata metadata = new MetadataSources((ServiceRegistry)serviceRegistry).buildMetadata();
        SessionFactory sessionFactory = metadata.getSessionFactoryBuilder().build();
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
        MetadataBuilderImpl.MetadataBuildingOptionsImpl buildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistry);
        BootstrapContextImpl ctx = new BootstrapContextImpl(serviceRegistry, (MetadataBuildingOptions)buildingOptions);
        SessionFactoryOptionsBuilder sfOptions = new SessionFactoryOptionsBuilder(serviceRegistry, (BootstrapContext)ctx);
        SessionFactoryServiceRegistryImpl sessionFactoryServiceRegistry = new SessionFactoryServiceRegistryImpl((ServiceRegistryImplementor)serviceRegistry, Collections.emptyList(), Collections.emptyList(), sessionFactoryImplementor, (BootstrapContext)ctx, (SessionFactoryOptions)sfOptions);
        EventListenerRegistry eventListenerRegistry = EventListenerServiceInitiator.INSTANCE.initiateService((SessionFactoryServiceInitiatorContext)sessionFactoryServiceRegistry);
        EventListenerGroup eventEventListenerGroup = eventListenerRegistry.getEventListenerGroup(EventType.POST_INSERT);
        eventListenerRegistry.setListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[0]);
        Assert.assertTrue((String)"We should start off with no listeners", (eventEventListenerGroup.count() == 0 ? 1 : 0) != 0);
        FullTextIndexEventListener firstFullTextIndexEventListener = new FullTextIndexEventListener();
        eventListenerRegistry.setListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{firstFullTextIndexEventListener});
        eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new HibernateSearchIntegrator.DuplicationStrategyImpl(FullTextIndexEventListener.class));
        eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{new FullTextIndexEventListener()});
        Assert.assertTrue((String)("We should only have one listener, but we have " + eventEventListenerGroup.count()), (eventEventListenerGroup.count() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The instances should match", (firstFullTextIndexEventListener == eventEventListenerGroup.listeners().iterator().next() ? 1 : 0) != 0);
    }
}

