/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.search.Search;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.AlternateDocument;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class RamDirectoryTest
extends SearchInitializationTestBase {
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();

    @Test
    public void localHeap() throws Exception {
        this.doTest("local-heap");
    }

    @Test
    public void ram() throws Exception {
        this.logged.expectMessage("HSEARCH000346");
        this.doTest("ram");
    }

    private void doTest(String directoryProviderName) throws Exception {
        this.init(directoryProviderName, Document.class, AlternateDocument.class);
        Session s = this.getTestResourceManager().openSession();
        s.getTransaction().begin();
        Document document = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
        s.persist((Object)document);
        s.flush();
        s.persist((Object)new AlternateDocument(document.getId(), "Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        Assert.assertEquals((long)2L, (long)this.getDocumentNbr());
        s = this.getTestResourceManager().openSession();
        s.getTransaction().begin();
        TermQuery q = new TermQuery(new Term("alt_title", "hibernate"));
        List hibernateDocuments = Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class}).list();
        Assert.assertEquals((String)"does not properly filter", (long)0L, (long)hibernateDocuments.size());
        Assert.assertEquals((String)"does not properly filter", (long)1L, (long)Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class, AlternateDocument.class}).list().size());
        s.delete(s.get(AlternateDocument.class, (Serializable)document.getId()));
        s.getTransaction().commit();
        s.close();
        Assert.assertEquals((long)1L, (long)this.getDocumentNbr());
        s = this.getTestResourceManager().openSession();
        s.getTransaction().begin();
        s.delete(s.createCriteria(Document.class).uniqueResult());
        s.getTransaction().commit();
        s.close();
    }

    private void init(String directoryProviderName, Class<?> ... classes) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("hibernate.search.default.directory_provider", directoryProviderName);
        this.init(new ImmutableTestConfiguration(settings, classes));
    }

    private int getDocumentNbr() throws Exception {
        return this.getBackendTestHelper().getNumberOfDocumentsInIndex((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(Document.class));
    }
}

