/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.Serializable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.impl.PerTransactionWorker;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-4225")
public class NoTransactionTest
extends SearchTestBase {
    @Test
    public void flush() throws Exception {
        long doc2Id;
        long doc1Id;
        try (Session session = this.getSessionFactory().openSession();){
            Document doc1 = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
            session.persist((Object)doc1);
            Document doc2 = new Document("Lucene in Action", "FullText search engine", "blah blah blah");
            session.persist((Object)doc2);
            session.flush();
            doc1Id = doc1.getId();
            doc2Id = doc2.getId();
        }
        Assertions.assertThat((int)this.countDocuments()).isEqualTo(2);
        this.purgeIndex();
        Assertions.assertThat((int)this.countDocuments()).isZero();
        session = this.getSessionFactory().openSession();
        var6_2 = null;
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            fullTextSession.setHibernateFlushMode(FlushMode.MANUAL);
            fullTextSession.setCacheMode(CacheMode.IGNORE);
            fullTextSession.index(session.load(Document.class, (Serializable)Long.valueOf(doc1Id)));
            fullTextSession.index(session.load(Document.class, (Serializable)Long.valueOf(doc2Id)));
            fullTextSession.flush();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var6_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
        Assertions.assertThat((int)this.countDocuments()).isEqualTo(2);
    }

    @Test
    public void flushToIndexes() throws Exception {
        long doc2Id;
        long doc1Id;
        try (Session session = this.getSessionFactory().openSession();){
            Document doc1 = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
            session.persist((Object)doc1);
            Document doc2 = new Document("Lucene in Action", "FullText search engine", "blah blah blah");
            session.persist((Object)doc2);
            session.flush();
            doc1Id = doc1.getId();
            doc2Id = doc2.getId();
        }
        Assertions.assertThat((int)this.countDocuments()).isEqualTo(2);
        this.purgeIndex();
        Assertions.assertThat((int)this.countDocuments()).isZero();
        session = this.getSessionFactory().openSession();
        var6_2 = null;
        try {
            session.setHibernateFlushMode(FlushMode.MANUAL);
            session.setCacheMode(CacheMode.IGNORE);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            fullTextSession.index(session.load(Document.class, (Serializable)Long.valueOf(doc1Id)));
            fullTextSession.index(session.load(Document.class, (Serializable)Long.valueOf(doc2Id)));
            fullTextSession.flushToIndexes();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var6_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
        Assertions.assertThat((int)this.countDocuments()).isEqualTo(2);
    }

    @After
    public void checkMemory() {
        System.gc();
        Assertions.assertThat(this.getPerTransactionWorker().synchronizationPerTransactionForTests().entrySet().iterator()).isEmpty();
        Assertions.assertThat(this.getFullTextIndexEventListener().flushSynchForTests().entrySet().iterator()).isEmpty();
    }

    private void purgeIndex() {
        try (Session session = this.getSessionFactory().openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            fullTextSession.purgeAll(Document.class);
            tx.commit();
        }
    }

    private PerTransactionWorker getPerTransactionWorker() {
        return (PerTransactionWorker)((SearchIntegrator)this.getSearchFactory().unwrap(SearchIntegrator.class)).getWorker();
    }

    private FullTextIndexEventListener getFullTextIndexEventListener() {
        for (FlushEventListener listener : ((EventListenerRegistry)((SessionFactoryImplementor)this.getSessionFactory().unwrap(SessionFactoryImplementor.class)).getServiceRegistry().getService(EventListenerRegistry.class)).getEventListenerGroup(EventType.FLUSH).listeners()) {
            if (!(listener instanceof FullTextIndexEventListener)) continue;
            return (FullTextIndexEventListener)listener;
        }
        throw new IllegalStateException("FullTextIndexEventListener not found?");
    }

    private int countDocuments() {
        return this.getNumberOfDocumentsInIndex(Document.class);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.allow_update_outside_transaction", "true");
    }
}

