/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;

public class DateSplitBridge
implements FieldBridge,
MetadataProvidingFieldBridge {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String YEAR_SUFFIX = "_year";
    private static final String MONTH_SUFFIX = "_month";
    private static final String DAY_SUFFIX = "_day";

    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(name + YEAR_SUFFIX, FieldType.STRING).field(name + MONTH_SUFFIX, FieldType.STRING).field(name + DAY_SUFFIX, FieldType.STRING);
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        Date date = (Date)value;
        Calendar cal = GregorianCalendar.getInstance(GMT, Locale.ROOT);
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        luceneOptions.addFieldToDocument(name + YEAR_SUFFIX, String.valueOf(year), document);
        luceneOptions.addFieldToDocument(name + MONTH_SUFFIX, month < 10 ? "0" : "" + String.valueOf(month), document);
        luceneOptions.addFieldToDocument(name + DAY_SUFFIX, day < 10 ? "0" : "" + String.valueOf(day), document);
    }
}

