/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.SearchTestBase;
import org.junit.Assert;
import org.junit.Before;

public abstract class ConfigurationReadTestCase
extends SearchTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        fullTextSession.close();
    }

    protected final void assertValueIsDefault(Class testEntity, IndexWriterSetting setting) {
        this.assertValueIsDefault(testEntity, 0, setting);
    }

    protected final void assertValueIsDefault(Class testEntity, int shard, IndexWriterSetting setting) {
        Assert.assertNull((String)("shard:" + shard + " setting:" + setting.getKey() + " : value was expected unset!"), (Object)this.getParameter(shard, setting, testEntity));
    }

    protected final void assertValueIsSet(Class testEntity, IndexWriterSetting setting, int expectedValue) {
        this.assertValueIsSet(testEntity, 0, setting, expectedValue);
    }

    protected final void assertValueIsSet(Class testEntity, int shard, IndexWriterSetting setting, int expectedValue) {
        Integer actualValue = this.getParameter(shard, setting, testEntity);
        Assert.assertNotNull((String)("shard:" + shard + " setting:" + setting.getKey()), (Object)actualValue);
        Assert.assertEquals((String)("shard:" + shard + " setting:" + setting.getKey()), (long)expectedValue, (long)actualValue.intValue());
    }

    private Integer getParameter(int shard, IndexWriterSetting setting, Class testEntity) {
        EntityIndexBinding mappingForEntity = (EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(testEntity);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)this.getIndexManager(mappingForEntity, shard);
        LuceneIndexingParameters luceneIndexingParameters = indexManager.getIndexingParameters();
        return luceneIndexingParameters.getIndexParameters().getCurrentValueFor(setting);
    }

    protected final IndexManager getIndexManager(EntityIndexBinding mappingForEntity, int shardIndex) {
        Set indexManagers = mappingForEntity.getIndexManagerSelector().all();
        if (shardIndex == 0 && indexManagers.size() == 1) {
            return (IndexManager)indexManagers.iterator().next();
        }
        for (IndexManager indexManager : mappingForEntity.getIndexManagerSelector().all()) {
            if (!indexManager.getIndexName().endsWith("." + shardIndex)) continue;
            return indexManager;
        }
        throw new IllegalStateException("Could not find IndexManager for shard " + shardIndex + " for binding " + mappingForEntity);
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.indexBase", this.getBaseIndexDir().toAbsolutePath().toString());
    }

    public static void assertCfgIsInvalid(Configuration configuration, Class[] mapping) {
        try {
            for (Class annotated : mapping) {
                configuration.addAnnotatedClass(annotated);
            }
            configuration.setProperty("hibernate.search.default.directory_provider", "local-heap");
            configuration.buildSessionFactory();
            Assert.fail();
        }
        catch (HibernateException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof SearchException));
        }
    }
}

