/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.testing.RequiresDialect;
import org.junit.Assert;
import org.junit.Test;

@RequiresDialect(comment="The connection provider for this test ignores configuration and requires H2", strictMatching=true, value={H2Dialect.class})
public class ContainedInMultiTenancyTest
extends SearchTestBase {
    private static final String TENANT_ID_1 = "tenant1";
    private static final String TENANT_ID_2 = "tenant2";

    @Test
    @TestForIssue(jiraKey="HSEARCH-3647")
    public void testContainedInProcessingRemembersTenantId() {
        Transaction transaction;
        try (Session session = this.openSession(TENANT_ID_1);){
            transaction = session.beginTransaction();
            Containing containing = new Containing();
            containing.setId(1L);
            ContainedLevel1 contained1 = new ContainedLevel1();
            contained1.setId(2L);
            containing.setContained(contained1);
            contained1.setContaining(containing);
            ContainedLevel2 contained2 = new ContainedLevel2();
            contained2.setId(3L);
            contained2.setField(1);
            contained1.setContained(contained2);
            contained2.setContaining(contained1);
            session.persist((Object)contained2);
            session.persist((Object)contained1);
            session.persist((Object)containing);
            transaction.commit();
        }
        Assert.assertEquals((long)1L, (long)this.queryResultSize(TENANT_ID_1, 1));
        Assert.assertEquals((long)0L, (long)this.queryResultSize(TENANT_ID_2, 1));
        session = this.openSession(TENANT_ID_1);
        var3_2 = null;
        try {
            transaction = session.beginTransaction();
            ContainedLevel2 contained = (ContainedLevel2)session.getReference(ContainedLevel2.class, (Object)3L);
            contained.setField(2);
            transaction.commit();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var3_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)this.queryResultSize(TENANT_ID_1, 2));
        Assert.assertEquals((long)0L, (long)this.queryResultSize(TENANT_ID_2, 2));
        Assert.assertEquals((long)0L, (long)this.queryResultSize(TENANT_ID_1, 1));
    }

    private Session openSession(String tenantId) {
        return this.getSessionFactory().withOptions().tenantIdentifier(tenantId).openSession();
    }

    private int queryResultSize(String tenantId, int fieldValue) {
        try (Session session = this.openSession(tenantId);){
            FullTextSession ftSession = Search.getFullTextSession((Session)session);
            QueryBuilder builder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(Containing.class).get();
            Query luceneQuery = builder.keyword().onField("contained.contained.field").matching((Object)fieldValue).createQuery();
            FullTextQuery query = ftSession.createFullTextQuery(luceneQuery, new Class[]{Containing.class});
            int n = query.getResultSize();
            return n;
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Containing.class, ContainedLevel1.class, ContainedLevel2.class};
    }

    @Override
    public Set<String> multiTenantIds() {
        return new HashSet<String>(Arrays.asList(TENANT_ID_1, TENANT_ID_2));
    }

    @Entity(name="contained2")
    private static class ContainedLevel2 {
        @Id
        private long id;
        @Basic
        @Field
        private int field;
        @OneToOne(mappedBy="contained")
        @ContainedIn
        private ContainedLevel1 containing;

        protected ContainedLevel2() {
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public int getField() {
            return this.field;
        }

        public void setField(int field) {
            this.field = field;
        }

        public ContainedLevel1 getContaining() {
            return this.containing;
        }

        public void setContaining(ContainedLevel1 containing) {
            this.containing = containing;
        }
    }

    @Entity(name="contained1")
    private static class ContainedLevel1 {
        @Id
        private long id;
        @OneToOne(mappedBy="contained")
        @ContainedIn
        private Containing containing;
        @OneToOne
        @IndexedEmbedded
        private ContainedLevel2 contained;

        protected ContainedLevel1() {
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public Containing getContaining() {
            return this.containing;
        }

        public void setContaining(Containing containing) {
            this.containing = containing;
        }

        public ContainedLevel2 getContained() {
            return this.contained;
        }

        public void setContained(ContainedLevel2 contained) {
            this.contained = contained;
        }
    }

    @Indexed
    @Entity(name="containing")
    private static class Containing {
        @Id
        private long id;
        @OneToOne
        @IndexedEmbedded
        private ContainedLevel1 contained;

        protected Containing() {
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public ContainedLevel1 getContained() {
            return this.contained;
        }

        public void setContained(ContainedLevel1 contained) {
            this.contained = contained;
        }
    }
}

