/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.boost.embeddable;

import java.util.List;
import java.util.Locale;
import org.apache.lucene.search.Query;
import org.assertj.core.api.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.boost.embeddable.LocalizedTitle;
import org.hibernate.search.test.query.boost.embeddable.Magazine;
import org.hibernate.search.test.query.boost.embeddable.Title;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Test;

public class EmbeddedFieldBoostTest
extends SearchTestBase {
    @Test
    @TestForIssue(jiraKey="HSEARCH-1804")
    public void testBoostedIndexEmbeddedEntity() {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        Magazine highPerfComputing = new Magazine(1L, "High-perf trends", new Title("High Performance Computing", "Faster, faster, faster"));
        highPerfComputing.getTitle().setLocalizedTitle(new LocalizedTitle(1L, Locale.FRENCH, "Informatique hautes-performances"));
        fullTextSession.persist((Object)highPerfComputing);
        Magazine roseGrowers = new Magazine(2L, null, new Title("Rose Grower's Weekly", "No petunia here"));
        roseGrowers.getTitle().setLocalizedTitle(new LocalizedTitle(2L, Locale.FRENCH, "L'hebdomadaire des cultivateurs de roses"));
        fullTextSession.persist((Object)roseGrowers);
        Magazine astronautDigest = new Magazine(3L, null, new Title("Astronaut Digest", "Tips for astronauts"));
        astronautDigest.getTitle().setLocalizedTitle(new LocalizedTitle(3L, Locale.FRENCH, "Le br\u00e9viaire des astronautes"));
        fullTextSession.persist((Object)astronautDigest);
        Magazine diyMagazine = new Magazine(4L, null, new Title("DIY magazine", "The do-it-yourself magazine"));
        diyMagazine.getTitle().setLocalizedTitle(new LocalizedTitle(4L, Locale.FRENCH, "Brico magazine"));
        fullTextSession.persist((Object)diyMagazine);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Magazine.class).get();
        Query query = queryBuilder.bool().should(queryBuilder.keyword().onField("title.value").matching((Object)"rose").createQuery()).should(queryBuilder.keyword().onField("description").matching((Object)"trends").createQuery()).should(queryBuilder.keyword().onField("title.subTitle.value").matching((Object)"tips").createQuery()).should(queryBuilder.keyword().onField("title.localizedTitle.value").matching((Object)"brico").createQuery()).createQuery();
        Assertions.assertThat((List)fullTextSession.createFullTextQuery(query, new Class[]{Magazine.class}).list()).describedAs("Query results are not in the order expected as per configured field boosts", new Object[0]).extracting("id").containsExactly(new Object[]{2L, 4L, 3L, 1L});
        tx.commit();
        fullTextSession.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Magazine.class, LocalizedTitle.class};
    }
}

