/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.FacetEncodingType;
import org.hibernate.search.annotations.Facets;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.bridge.builtin.IntegerBridge;

@Entity
@Indexed
@AnalyzerDefs(value={@AnalyzerDef(name="org_hibernate_search_test_query_facet_Car_collatingAnalyzer", tokenizer=@TokenizerDef(factory=KeywordTokenizerFactory.class), filters={@TokenFilterDef(factory=ASCIIFoldingFilterFactory.class), @TokenFilterDef(factory=LowerCaseFilterFactory.class)})})
public class Car {
    public static final String COLLATING_ANALYZER_NAME = "org_hibernate_search_test_query_facet_Car_collatingAnalyzer";
    public static final String CUBIC_CAPACITY_STRING = "cubicCapacity_string";
    public static final String CUBIC_CAPACITY_STRING_FACET_STRING_ENCODING = "cubicCapacity_string_facet_string";
    public static final String CUBIC_CAPACITY_STRING_FACET_NUMERIC_ENCODING = "cubicCapacity_string_facet_numeric";
    @Id
    @GeneratedValue
    private int id;
    @Field(analyze=Analyze.NO)
    @Facet
    private String color;
    @Fields(value={@Field(analyze=Analyze.NO, store=Store.YES), @Field(name="facetNameCollision", store=Store.YES, analyzer=@Analyzer(definition="org_hibernate_search_test_query_facet_Car_collatingAnalyzer"))})
    @Facets(value={@Facet, @Facet(name="facetNameCollision")})
    private String make;
    @Field(name="cubicCapacity_string", analyze=Analyze.NO, bridge=@FieldBridge(impl=IntegerBridge.class))
    @Facets(value={@Facet(name="cubicCapacity_string_facet_string", forField="cubicCapacity_string", encoding=FacetEncodingType.STRING), @Facet(name="cubicCapacity_string_facet_numeric", forField="cubicCapacity_string", encoding=FacetEncodingType.LONG)})
    private Integer cubicCapacity;

    public Car() {
    }

    public Car(String make, String color, Integer cubicCapacity) {
        this.color = color;
        this.cubicCapacity = cubicCapacity;
        this.make = make;
    }

    public String getColor() {
        return this.color;
    }

    public Integer getCubicCapacity() {
        return this.cubicCapacity;
    }

    public int getId() {
        return this.id;
    }

    public String getMake() {
        return this.make;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Car");
        sb.append("{id=").append(this.id);
        sb.append(", color='").append(this.color).append('\'');
        sb.append(", make='").append(this.make).append('\'');
        sb.append(", cubicCapacity=").append(this.cubicCapacity);
        sb.append('}');
        return sb.toString();
    }
}

