/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.objectloading;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;

@Entity
@Indexed
public class TestEntity {
    @Id
    private int entityId;
    @DocumentId
    private String documentId;

    private TestEntity() {
    }

    public TestEntity(int entityId, String documentId) {
        this.entityId = entityId;
        this.documentId = documentId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestEntity that = (TestEntity)o;
        if (this.entityId != that.entityId) {
            return false;
        }
        return this.documentId.equals(that.documentId);
    }

    public int hashCode() {
        int result = this.entityId;
        result = 31 * result + this.documentId.hashCode();
        return result;
    }

    public String toString() {
        return "TestEntity{entityId=" + this.entityId + ", documentId='" + this.documentId + '\'' + '}';
    }
}

