/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.progessmonitor;

import java.util.concurrent.atomic.LongAdder;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.SimpleIndexingProgressMonitor;
import org.junit.Assert;

public class AssertingMassIndexerProgressMonitor
implements MassIndexerProgressMonitor {
    private final MassIndexerProgressMonitor monitor;
    private final LongAdder totalCount = new LongAdder();
    private final LongAdder finishedCount = new LongAdder();
    private final LongAdder addedDocuments = new LongAdder();
    private final long expectedAddedDocuments;
    private final long expectedTotalCount;

    public AssertingMassIndexerProgressMonitor(int expectedAddedDocuments, int expectedTotalCount) {
        this.expectedAddedDocuments = expectedAddedDocuments;
        this.expectedTotalCount = expectedTotalCount;
        this.monitor = new SimpleIndexingProgressMonitor(1);
    }

    public void documentsAdded(long increment) {
        this.addedDocuments.add(increment);
        this.monitor.documentsAdded(increment);
    }

    public void documentsBuilt(int number) {
        this.monitor.documentsBuilt(number);
    }

    public void entitiesLoaded(int size) {
        this.monitor.entitiesLoaded(size);
    }

    public void addToTotalCount(long count) {
        this.totalCount.add(count);
        this.monitor.addToTotalCount(count);
    }

    public void indexingCompleted() {
        this.finishedCount.add(1L);
    }

    public void assertExpectedProgressMade() {
        Assert.assertEquals((String)"Unexpected number of added documents", (long)this.expectedAddedDocuments, (long)this.addedDocuments.longValue());
        Assert.assertEquals((String)"Unexpected total count", (long)this.expectedTotalCount, (long)this.totalCount.longValue());
        Assert.assertEquals((String)"Finished called more than once", (long)1L, (long)this.finishedCount.longValue());
    }
}

