/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.util.Properties;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.impl.RAMDirectoryProvider;

public class CloseCheckingDirectoryProvider
extends RAMDirectoryProvider {
    private volatile boolean initialized = false;
    private volatile boolean stopped = false;
    private volatile boolean started = false;

    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        super.initialize(directoryProviderName, properties, context);
        if (this.initialized) {
            throw new SearchException("Initialized twice");
        }
        if (this.started) {
            throw new SearchException("Initialized after start");
        }
        if (this.stopped) {
            throw new SearchException("Initialized after stop");
        }
        this.initialized = true;
    }

    public void start(DirectoryBasedIndexManager indexManager) {
        super.start(indexManager);
        if (!this.initialized) {
            throw new SearchException("Started without being initialized");
        }
        if (this.started) {
            throw new SearchException("Started twice");
        }
        if (this.stopped) {
            throw new SearchException("Can not be started after being stopped");
        }
        this.started = true;
    }

    public RAMDirectory getDirectory() {
        if (!this.initialized) {
            throw new SearchException("Can not be used before initialization");
        }
        if (!this.started) {
            throw new SearchException("Can not be used before being started");
        }
        if (this.stopped) {
            throw new SearchException("Can not be used after being stopped");
        }
        return super.getDirectory();
    }

    public void stop() {
        super.stop();
        if (!this.initialized) {
            throw new SearchException("Stopped before initialization");
        }
        if (!this.started) {
            throw new SearchException("Stopped before being started");
        }
        if (this.stopped) {
            throw new SearchException("Stopped twice");
        }
        this.stopped = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isStarted() {
        return this.started;
    }
}

