/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2486")
public class ContainedInEntityInheritanceTest
extends SearchTestBase {
    @Test
    public void testContainedInIsInherited() {
        Containing containing;
        Transaction transaction;
        try (Session session = this.openSession();){
            transaction = session.beginTransaction();
            containing = new Containing();
            session.save((Object)containing);
            Contained contained = new Contained();
            containing.contained = contained;
            contained.containing = containing;
            session.save((Object)contained);
            session.save((Object)containing);
            transaction.commit();
        }
        Assert.assertEquals((long)1L, (long)this.queryResultSize(0));
        session = this.openSession();
        var3_2 = null;
        try {
            transaction = session.beginTransaction();
            containing = (Containing)session.byId(Containing.class).load((Serializable)Long.valueOf(containing.id));
            ((Containing)containing).contained.field = 1;
            session.save((Object)containing.contained);
            transaction.commit();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var3_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)this.queryResultSize(1));
        Assert.assertEquals((long)0L, (long)this.queryResultSize(0));
    }

    private int queryResultSize(int fieldValue) {
        try (Session session = this.openSession();){
            FullTextSession ftSession = Search.getFullTextSession((Session)session);
            QueryBuilder builder = ftSession.getSearchFactory().buildQueryBuilder().forEntity(Containing.class).get();
            Query luceneQuery = builder.keyword().onField("contained.field").matching((Object)fieldValue).createQuery();
            FullTextQuery query = ftSession.createFullTextQuery(luceneQuery, new Class[]{Containing.class});
            int n = query.getResultSize();
            return n;
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Containing.class, AbstractContained.class, Contained.class};
    }

    @Entity(name="contained")
    private static class Contained
    extends AbstractContained {
        @Id
        @GeneratedValue
        private long id;

        private Contained() {
        }
    }

    @MappedSuperclass
    private static class AbstractContained {
        @OneToOne(mappedBy="contained")
        @ContainedIn
        Containing containing;
        @Field
        int field;

        private AbstractContained() {
        }
    }

    @Indexed
    @Entity(name="containing")
    private static class Containing {
        @Id
        @GeneratedValue
        private long id;
        @OneToOne
        @IndexedEmbedded
        private Contained contained;

        private Containing() {
        }
    }
}

