/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.filter.impl.CachingWrapperQuery;

public class FieldConstraintFilterFactory {
    private String field;
    private String value;

    @Factory
    public Query buildFilter() {
        TermQuery q = new TermQuery(new Term(this.field, this.value));
        return new CachingWrapperQuery((Query)q);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Key
    public FilterKey getKey() {
        StandardFilterKey key = new StandardFilterKey();
        key.addParameter((Object)this.field);
        key.addParameter((Object)this.value);
        return key;
    }
}

