/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;

public final class ResourceCleanupFunctions {
    private ResourceCleanupFunctions() {
    }

    public static void withinEntityManager(EntityManagerFactory emf, Consumer<FullTextEntityManager> consumer) {
        try (EntityManager entityManager = emf.createEntityManager();){
            FullTextEntityManager fem = Search.getFullTextEntityManager((EntityManager)entityManager);
            consumer.accept(fem);
        }
    }

    public static void withinTransaction(EntityManager em, Runnable codeblock) {
        EntityTransaction transaction = em.getTransaction();
        transaction.begin();
        try {
            codeblock.run();
            transaction.commit();
        }
        catch (Throwable mainError) {
            try {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
            }
            catch (Throwable errorOnRollBack) {
                mainError.addSuppressed(errorOnRollBack);
            }
            throw mainError;
        }
    }
}

