/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.ExclusiveIndexWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.SharedIndexWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.WorkspaceHolder;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class ExclusiveIndexTest {
    @Test
    public void verifyIndexExclusivity() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        FullTextSession ftSession = builder.setProperty("hibernate.search.org.hibernate.search.test.configuration.BlogEntry.exclusive_index_use", "true").setProperty("hibernate.search.Book.exclusive_index_use", "false").addAnnotatedClass(BlogEntry.class).addAnnotatedClass(Foo.class).addAnnotatedClass(Book.class).addAnnotatedClass(Author.class).openFullTextSession();
        ExtendedSearchIntegrator integrator = (ExtendedSearchIntegrator)ftSession.getSearchFactory().unwrap(ExtendedSearchIntegrator.class);
        ftSession.close();
        IndexManagerHolder allIndexesManager = integrator.getIndexManagerHolder();
        this.assertExclusiveIsEnabled(allIndexesManager, "org.hibernate.search.test.configuration.BlogEntry", true);
        this.assertExclusiveIsEnabled(allIndexesManager, "Book", false);
        this.assertExclusiveIsEnabled(allIndexesManager, Foo.class.getName(), true);
        builder.close();
    }

    private void assertExclusiveIsEnabled(IndexManagerHolder allIndexesManager, String indexName, boolean expectExclusive) {
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)allIndexesManager.getIndexManager(indexName);
        WorkspaceHolder workspaceHolder = indexManager.getWorkspaceHolder();
        AbstractWorkspaceImpl workspace = workspaceHolder.getIndexResources().getWorkspace();
        if (expectExclusive) {
            Assert.assertEquals(ExclusiveIndexWorkspaceImpl.class, workspace.getClass());
        } else {
            Assert.assertEquals(SharedIndexWorkspaceImpl.class, workspace.getClass());
        }
    }

    @Indexed
    @Entity
    @Table(name="Foo")
    public static class Foo {
        @Id
        private int id;
    }
}

