/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.batchindexing.IndexedEmbeddedProxyLazyEntity;
import org.hibernate.search.test.batchindexing.IndexedEmbeddedProxyRootEntity;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1240")
public class MassIndexerIndexedEmbeddedProxyTest
extends SearchTestBase {
    private static final String TEST_NAME_CONTENT = "name";

    @Test
    public void testMassIndexerWithProxyTest() throws InterruptedException {
        this.prepareEntities();
        this.verifyMatchExistsWithName("lazyEntity.name", TEST_NAME_CONTENT);
        this.verifyMatchExistsWithName("lazyEntity2.name", TEST_NAME_CONTENT);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        MassIndexer massIndexer = fullTextSession.createIndexer(new Class[]{IndexedEmbeddedProxyRootEntity.class});
        massIndexer.startAndWait();
        fullTextSession.close();
        this.verifyMatchExistsWithName("lazyEntity.name", TEST_NAME_CONTENT);
        this.verifyMatchExistsWithName("lazyEntity2.name", TEST_NAME_CONTENT);
    }

    @Test
    public void testMassIndexerRepeatedInvocation() throws InterruptedException {
        this.prepareEntities();
        this.verifyMatchExistsWithName("lazyEntity.name", TEST_NAME_CONTENT);
        this.verifyMatchExistsWithName("lazyEntity2.name", TEST_NAME_CONTENT);
        for (int i = 0; i < 4; ++i) {
            try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
                Transaction tx = fullTextSession.beginTransaction();
                fullTextSession.purgeAll(IndexedEmbeddedProxyRootEntity.class);
                tx.commit();
            }
            this.verifyIndexIsEmpty();
            fullTextSession = Search.getFullTextSession((Session)this.openSession());
            var3_3 = null;
            try {
                MassIndexer massIndexer = fullTextSession.createIndexer(new Class[]{IndexedEmbeddedProxyRootEntity.class});
                massIndexer.startAndWait();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (fullTextSession != null) {
                    if (var3_3 != null) {
                        try {
                            fullTextSession.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        fullTextSession.close();
                    }
                }
            }
            this.verifyMatchExistsWithName("lazyEntity.name", TEST_NAME_CONTENT);
            this.verifyMatchExistsWithName("lazyEntity2.name", TEST_NAME_CONTENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIndexIsEmpty() {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            MatchAllDocsQuery q = new MatchAllDocsQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            List list = fullTextQuery.list();
            Assert.assertEquals((long)0L, (long)resultSize);
            Assert.assertTrue((boolean)list.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareEntities() {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            IndexedEmbeddedProxyLazyEntity lazyEntity = new IndexedEmbeddedProxyLazyEntity();
            lazyEntity.setName(TEST_NAME_CONTENT);
            session.save((Object)lazyEntity);
            IndexedEmbeddedProxyRootEntity rootEntity = new IndexedEmbeddedProxyRootEntity();
            rootEntity.setLazyEntity(lazyEntity);
            rootEntity.setLazyEntity2(lazyEntity);
            session.save((Object)rootEntity);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyMatchExistsWithName(String fieldName, String fieldValue) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term(fieldName, fieldValue));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            Assert.assertEquals((long)1L, (long)resultSize);
            List list = fullTextQuery.list();
            Assert.assertEquals((long)1L, (long)list.size());
            transaction.commit();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{IndexedEmbeddedProxyRootEntity.class, IndexedEmbeddedProxyLazyEntity.class};
    }
}

