/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.query.Music;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiClassesQueryLoaderTest
extends SearchTestBase {
    private Query luceneQuery;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        try (Session session = this.openSession();){
            Transaction tx = session.beginTransaction();
            Author author = new Author();
            author.setName("Moo Cow");
            Music music = new Music();
            music.addAuthor(author);
            music.setTitle("The moo moo mooing under the stars");
            Book book = new Book();
            book.setBody("This is the story of the Moo Cow, who sang the moo moo moo at night");
            book.setId(1);
            session.persist((Object)book);
            session.persist((Object)author);
            session.persist((Object)music);
            Author charles = new Author();
            charles.setName("Charles Dickens");
            session.persist((Object)charles);
            tx.commit();
        }
        QueryParser parser = new QueryParser("title", TestConstants.keywordAnalyzer);
        this.luceneQuery = parser.parse("name:moo OR title:moo OR body:moo");
    }

    @Test
    public void testObjectNotFound() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Statement statement = connection.createStatement();
                statement.executeUpdate("DELETE FROM Author where name = 'Charles Dickens'");
                statement.close();
            }
        });
        FullTextSession s = Search.getFullTextSession((Session)session);
        QueryParser parser = new QueryParser("title", TestConstants.keywordAnalyzer);
        Query query = parser.parse("name:charles");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Author.class, Music.class});
        List result = hibQuery.list();
        Assert.assertEquals((String)"Should have returned no author", (long)0L, (long)result.size());
        tx.commit();
        s.close();
    }

    @Test
    public void testObjectTypeFilteringSingleClass() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.luceneQuery, new Class[]{Music.class});
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match the music only", (long)1L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testObjectTypeFilteringTwoClasses() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.luceneQuery, new Class[]{Author.class, Music.class});
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match the author and music only", (long)2L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testObjectTypeFilteringThreeClasses() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.luceneQuery, new Class[]{Author.class, Music.class, Book.class});
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match the author, music and book", (long)3L, (long)result.size());
        fullTextQuery = fullTextSession.createFullTextQuery(this.luceneQuery, new Class[0]);
        result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match all types", (long)3L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testImplicitObjectTypeFiltering() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.luceneQuery, new Class[0]);
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match all types", (long)3L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Author.class, Music.class, Book.class};
    }
}

