/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.boost;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.boost.DynamicBoostedDescriptionLibrary;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class DynamicBoostingTest
extends SearchTestBase {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());

    @Test
    public void testDynamicBoosts() throws Exception {
        Session session = this.openSession();
        session.beginTransaction();
        DynamicBoostedDescriptionLibrary lib1 = new DynamicBoostedDescriptionLibrary();
        lib1.setName("one");
        session.persist((Object)lib1);
        DynamicBoostedDescriptionLibrary lib2 = new DynamicBoostedDescriptionLibrary();
        lib2.setName("two");
        session.persist((Object)lib2);
        session.getTransaction().commit();
        session.close();
        float lib1Score = this.getScore((Query)new TermQuery(new Term("name", "one")));
        float lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        Assert.assertEquals((String)"The scores should be equal", (float)lib1Score, (float)lib2Score, (float)0.0f);
        session = this.openSession();
        session.beginTransaction();
        session.refresh((Object)lib2);
        lib2.setDynScore(2.0f);
        session.getTransaction().commit();
        session.close();
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "one")));
        lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        Assert.assertTrue((String)"lib2score should be greater than lib1score", (lib1Score < lib2Score ? 1 : 0) != 0);
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "foobar")));
        Assert.assertEquals((String)"lib1score should be 0 since term is not yet indexed.", (float)0.0f, (float)lib1Score, (float)0.0f);
        session = this.openSession();
        session.beginTransaction();
        session.refresh((Object)lib1);
        lib1.setName("foobar");
        session.getTransaction().commit();
        session.close();
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "foobar")));
        lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        Assert.assertTrue((String)"lib1score should be greater than lib2score", (lib1Score > lib2Score ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getScore(Query query) {
        float score;
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            List resultList = fullTextSession.createFullTextQuery(query, new Class[]{DynamicBoostedDescriptionLibrary.class}).setProjection(new String[]{"__HSearch_Score", "__HSearch_Explanation"}).setMaxResults(1).list();
            if (resultList.size() == 0) {
                score = 0.0f;
            } else {
                Object[] queryResult = (Object[])resultList.get(0);
                score = ((Float)queryResult[0]).floatValue();
                String explanation = queryResult[1].toString();
                log.debugf("score: %f explanation: %s", (Object)Float.valueOf(score), (Object)explanation);
            }
        }
        return score;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{DynamicBoostedDescriptionLibrary.class};
    }
}

