/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.sorting;

import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.assertj.core.api.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.sorting.Explorer;
import org.hibernate.search.test.query.sorting.Territory;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2021")
public class SortOnFieldsFromCustomBridgeTest
extends SearchTestBase {
    @Before
    public void insertTestData() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        Territory novaScotia = new Territory(1, "Nova Scotia");
        fullTextSession.save((Object)novaScotia);
        Territory alaska = new Territory(2, "Alaska");
        fullTextSession.save((Object)alaska);
        Territory tierraDelFuego = new Territory(3, "Tierra del Fuego");
        fullTextSession.save((Object)tierraDelFuego);
        fullTextSession.save((Object)new Explorer(1, 23, novaScotia, "Sam", "1st", "Seaman"));
        fullTextSession.save((Object)new Explorer(2, 22, alaska, "Sam", "2nd", "Traveller"));
        fullTextSession.save((Object)new Explorer(3, 22, tierraDelFuego, "Collin", "1st", "Conqueror"));
        tx.commit();
        fullTextSession.close();
    }

    @After
    public void deleteTestData() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.delete((Object)new Explorer(1));
        fullTextSession.delete((Object)new Explorer(2));
        fullTextSession.delete((Object)new Explorer(3));
        fullTextSession.delete((Object)new Territory(1));
        fullTextSession.delete((Object)new Territory(2));
        fullTextSession.delete((Object)new Territory(3));
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSortableFieldConfiguredThroughClassLevelBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        List result = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Explorer.class}).setSort(new Sort(new SortField[]{new SortField("fn_firstName", SortField.Type.STRING), new SortField("fn_middleName", SortField.Type.STRING)})).list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).extracting("id").containsExactly(new Object[]{3, 1, 2});
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSortableFieldConfiguredThroughCustomFieldLevelBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        List result = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Explorer.class}).setSort(new Sort(new SortField("nameParts_lastName", SortField.Type.STRING))).list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).extracting("id").containsExactly(new Object[]{3, 1, 2});
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testTwoSortableFieldsConfiguredThroughAnnotationAndCustomFieldLevelBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        List result = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Explorer.class}).setSort(new Sort(new SortField[]{new SortField("exploredCountries", SortField.Type.INT), new SortField("nameParts_lastName", SortField.Type.STRING)})).list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).extracting("id").containsExactly(new Object[]{3, 2, 1});
        tx.commit();
        fullTextSession.close();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2325")
    public void testNumericCustomFieldLevelBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        List result = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Explorer.class}).setSort(new Sort(new SortField("favoriteTerritory.idFromBridge", SortField.Type.INT))).list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).extracting("id").containsExactly(new Object[]{1, 2, 3});
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testSortableFieldConfiguredThroughClassLevelBridgeOnEmbeddedEntity() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        List result = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Explorer.class}).setSort(new Sort(new SortField("favoriteTerritory.territoryName", SortField.Type.STRING))).list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).extracting("id").containsExactly(new Object[]{2, 1, 3});
        tx.commit();
        fullTextSession.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Explorer.class, Territory.class};
    }
}

