/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.timeout;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.QueryTimeoutException;
import org.apache.lucene.search.Query;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.jpa.JPATestCase;
import org.hibernate.search.test.query.timeout.Clock;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class JPATimeoutTest
extends JPATestCase {
    @Test
    @BMRule(targetClass="QueryHits", targetMethod="updateTopDocs", helper="org.hibernate.search.testsupport.BytemanHelper", action="sleepASecond();", name="Enable QueryHits slow down")
    public void testQueryTimeoutException() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        for (long i = 0L; i < 1000L; ++i) {
            Clock clock = new Clock(i, "Model cat A" + i, i % 2L == 0L ? "Seiko" : "Swatch", 2000L + i);
            em.persist((Object)clock);
        }
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query query = builder.keyword().onField("brand").matching((Object)"Seiko").createQuery();
        FullTextQuery hibernateQuery = em.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.setHint("javax.persistence.query.timeout", (Object)100);
        try {
            hibernateQuery.getResultSize();
            Assert.fail((String)"timeout exception should happen");
        }
        catch (QueryTimeoutException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            Assert.fail((String)"Expected a QueryTimeoutException");
        }
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        Assert.assertEquals((long)1000L, (long)em.createQuery("delete from " + Clock.class.getName()).executeUpdate());
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void testLimitFetchingTime() {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        for (long i = 0L; i < 1000L; ++i) {
            Clock clock = new Clock(i, "Model cat A" + i, i % 2L == 0L ? "Seiko" : "Swatch", 2000L + i);
            em.persist((Object)clock);
        }
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query query = builder.keyword().onField("brand").matching((Object)"Seiko").createQuery();
        FullTextQuery hibernateQuery = em.createFullTextQuery(query, new Class[]{Clock.class});
        List results = hibernateQuery.getResultList();
        Assert.assertEquals((long)500L, (long)results.size());
        em.clear();
        query = builder.keyword().onField("brand").matching((Object)"Swatch").createQuery();
        hibernateQuery = em.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.limitExecutionTimeTo(1L, TimeUnit.NANOSECONDS);
        List result = hibernateQuery.getResultList();
        System.out.println("Result size early: " + result.size());
        Assert.assertEquals((String)"Test early failure, before the number of results are even fetched", (long)0L, (long)result.size());
        if (result.size() == 0) {
            Assert.assertTrue((boolean)hibernateQuery.hasPartialResults());
        }
        em.clear();
        hibernateQuery = em.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.limitExecutionTimeTo(30L, TimeUnit.SECONDS);
        results = hibernateQuery.getResultList();
        Assert.assertEquals((String)"Test below limit termination", (long)500L, (long)results.size());
        Assert.assertFalse((boolean)hibernateQuery.hasPartialResults());
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        Assert.assertEquals((long)1000L, (long)em.createQuery("delete from " + Clock.class.getName()).executeUpdate());
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    @Override
    protected void configure(Map cfg) {
        cfg.put("hibernate.jdbc.batch_size", "1000");
        super.configure(cfg);
    }
}

