/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.assertj.core.api.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.configuration.Item;
import org.hibernate.search.test.configuration.ProductCatalog;
import org.hibernate.search.test.configuration.ProgrammaticSearchMappingFactory;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class LuceneProgrammaticMappingTest
extends SearchTestBase {
    @Test
    public void testNumeric() throws Exception {
        Item item = new Item();
        item.setId(1);
        item.setPrice((short)3454);
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)item);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        Query q = s.getSearchFactory().buildQueryBuilder().forEntity(Item.class).get().all().createQuery();
        FullTextQuery query = s.createFullTextQuery(q, new Class[]{Item.class});
        List result = query.setProjection(new String[]{"__HSearch_Document", "__HSearch_This"}).list();
        Assert.assertEquals((String)"Numeric field via programmatic config", (long)1L, (long)query.getResultSize());
        Object[] row = (Object[])result.iterator().next();
        Document document = (Document)row[0];
        IndexableField priceNumeric = document.getField("price");
        Assertions.assertThat((Object)priceNumeric.numericValue()).isEqualTo((Object)3454);
        IndexableField priceString = document.getField("price_string");
        Assertions.assertThat((Object)priceString.numericValue()).isNull();
        Assertions.assertThat((String)priceString.stringValue()).isEqualTo((Object)"3454");
        s.delete(row[1]);
        tx.commit();
        s.close();
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.model_mapping", ProgrammaticSearchMappingFactory.class.getName());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ProductCatalog.class, Item.class, BlogEntry.class};
    }
}

