/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.assertj.core.api.Assertions;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.filter.Driver;
import org.hibernate.search.test.filter.Employee;
import org.hibernate.search.test.filter.FieldConstraintFilterFactoryWithoutKeyMethod;
import org.hibernate.search.test.filter.FieldConstraintFilterWithoutKeyMethod;
import org.hibernate.search.test.filter.FullTimeEmployee;
import org.hibernate.search.test.filter.InstanceBasedExcludeAllFilterFactory;
import org.hibernate.search.test.filter.PartTimeEmployee;
import org.hibernate.search.test.filter.Soap;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class FullTextFilterTest
extends SearchTestBase {
    private QueryCachingPolicy cachingPolicy;
    private BooleanQuery query;
    private FullTextSession fullTextSession;

    @Test
    public void testNamedFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        Assert.assertEquals((String)"No filter should happen", (long)3L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.disableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("bestDriver");
        Assert.assertEquals((String)"Should filter out Gavin", (long)2L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        Assert.assertEquals((String)"Should filter to limit to Emmanuel", (long)1L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        ftQuery.disableFullTextFilter("security");
        ftQuery.disableFullTextFilter("bestDriver");
        Assert.assertEquals((String)"Should not filter anymore", (long)3L, (long)ftQuery.getResultSize());
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testCache() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        Assert.assertEquals((String)"No filter should happen", (long)3L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheresultstest");
        Assert.assertEquals((String)"Should filter out all", (long)0L, (long)ftQuery.getResultSize());
        System.gc();
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheresultstest");
        try {
            ftQuery.getResultSize();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Cache results does not work");
        }
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancetest");
        InstanceBasedExcludeAllFilterFactory.assertInstancesCreated(0);
        Assert.assertEquals((String)"Should filter out all", (long)0L, (long)ftQuery.getResultSize());
        InstanceBasedExcludeAllFilterFactory.assertInstancesCreated(1);
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancetest");
        ftQuery.getResultSize();
        InstanceBasedExcludeAllFilterFactory.assertInstancesCreated(1);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-295")
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testFiltersCreatedByFactoryWithoutKeyMethodShouldBeCachedByAllParameterNamesAndValues() {
        Assert.assertEquals((long)0L, (long)FieldConstraintFilterFactoryWithoutKeyMethod.getBuiltFilters().size());
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        Assert.assertEquals((String)"No filter should happen", (long)3L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancefromfactorywithoutkeymethodtest").setParameter("field", (Object)"teacher").setParameter("value", (Object)"andre");
        Assert.assertEquals((long)1L, (long)ftQuery.getResultSize());
        Assertions.assertThat(FieldConstraintFilterFactoryWithoutKeyMethod.getBuiltFilters()).containsExactly((Object[])new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation[]{new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation("teacher", "andre")});
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancefromfactorywithoutkeymethodtest").setParameter("field", (Object)"teacher").setParameter("value", (Object)"max");
        Assert.assertEquals((long)1L, (long)ftQuery.getResultSize());
        Assertions.assertThat(FieldConstraintFilterFactoryWithoutKeyMethod.getBuiltFilters()).containsExactly((Object[])new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation[]{new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation("teacher", "andre"), new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation("teacher", "max")});
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancefromfactorywithoutkeymethodtest").setParameter("field", (Object)"teacher").setParameter("value", (Object)"andre");
        Assert.assertEquals((long)1L, (long)ftQuery.getResultSize());
        Assertions.assertThat(FieldConstraintFilterFactoryWithoutKeyMethod.getBuiltFilters()).containsExactly((Object[])new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation[]{new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation("teacher", "andre"), new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation("teacher", "max")});
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancefromfactorywithoutkeymethodtest").setParameter("value", (Object)"andre").setParameter("field", (Object)"teacher");
        Assert.assertEquals((long)1L, (long)ftQuery.getResultSize());
        Assertions.assertThat(FieldConstraintFilterFactoryWithoutKeyMethod.getBuiltFilters()).containsExactly((Object[])new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation[]{new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation("teacher", "andre"), new FieldConstraintFilterFactoryWithoutKeyMethod.BuildFilterInvocation("teacher", "max")});
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-295")
    @Category(value={SkipOnElasticsearch.class})
    public void testFiltersWithoutKeyMethodShouldBeCachedByAllParameterNamesAndValues() {
        FieldConstraintFilterWithoutKeyMethod.getInstances().clear();
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        Assert.assertEquals((String)"No filter should happen", (long)3L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancewithoutkeymethodtest").setParameter("field", (Object)"teacher").setParameter("value", (Object)"andre");
        Assert.assertEquals((long)1L, (long)ftQuery.getResultSize());
        Assertions.assertThat(FieldConstraintFilterWithoutKeyMethod.getInstances()).containsExactly((Object[])new FieldConstraintFilterWithoutKeyMethod[]{new FieldConstraintFilterWithoutKeyMethod("teacher", "andre")});
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancewithoutkeymethodtest").setParameter("field", (Object)"teacher").setParameter("value", (Object)"max");
        Assert.assertEquals((long)1L, (long)ftQuery.getResultSize());
        Assertions.assertThat(FieldConstraintFilterWithoutKeyMethod.getInstances()).containsExactly((Object[])new FieldConstraintFilterWithoutKeyMethod[]{new FieldConstraintFilterWithoutKeyMethod("teacher", "andre"), new FieldConstraintFilterWithoutKeyMethod("teacher", "max")});
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancewithoutkeymethodtest").setParameter("field", (Object)"teacher").setParameter("value", (Object)"andre");
        Assert.assertEquals((long)1L, (long)ftQuery.getResultSize());
        Assertions.assertThat(FieldConstraintFilterWithoutKeyMethod.getInstances()).containsExactly((Object[])new FieldConstraintFilterWithoutKeyMethod[]{new FieldConstraintFilterWithoutKeyMethod("teacher", "andre"), new FieldConstraintFilterWithoutKeyMethod("teacher", "max")});
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancewithoutkeymethodtest").setParameter("value", (Object)"andre").setParameter("field", (Object)"teacher");
        Assert.assertEquals((long)1L, (long)ftQuery.getResultSize());
        Assertions.assertThat(FieldConstraintFilterWithoutKeyMethod.getInstances()).containsExactly((Object[])new FieldConstraintFilterWithoutKeyMethod[]{new FieldConstraintFilterWithoutKeyMethod("teacher", "andre"), new FieldConstraintFilterWithoutKeyMethod("teacher", "max")});
    }

    @Test
    public void testStraightFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        TermQuery termQuery = new TermQuery(new Term("name", "liz"));
        QueryWrapperFilter termFilter = new QueryWrapperFilter((Query)termQuery);
        ftQuery.setFilter((Filter)termFilter);
        Assert.assertEquals((String)"Should select only liz", (long)1L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.setFilter((Filter)termFilter);
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        ftQuery.disableFullTextFilter("security");
        ftQuery.disableFullTextFilter("bestDriver");
        ftQuery.setFilter(null);
        Assert.assertEquals((String)"Should not filter anymore", (long)3L, (long)ftQuery.getResultSize());
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testEmptyFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        TermQuery termQuery = new TermQuery(new Term("name", "liz"));
        QueryWrapperFilter termFilter = new QueryWrapperFilter((Query)termQuery);
        ftQuery.setFilter((Filter)termFilter);
        Assert.assertEquals((String)"Should select only liz", (long)1L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("emptyWithDeprecatedFilterType");
        Assert.assertEquals((String)"two filters, one is empty, should not match anything", (long)0L, (long)ftQuery.getResultSize());
    }

    @TestForIssue(jiraKey="HSEARCH-1513")
    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testCachedEmptyFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        calendar.set(1, 2001);
        long from = DateTools.round((long)calendar.getTime().getTime(), (DateTools.Resolution)DateTools.Resolution.YEAR);
        calendar.set(1, 2005);
        long to = DateTools.round((long)calendar.getTime().getTime(), (DateTools.Resolution)DateTools.Resolution.YEAR);
        NumericRangeFilter dateFilter = NumericRangeFilter.newLongRange((String)"delivery", (Long)from, (Long)to, (boolean)true, (boolean)true);
        ftQuery.setFilter((Filter)dateFilter);
        Assert.assertEquals((String)"Should select only liz", (long)1L, (long)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("cached_empty");
        Assert.assertEquals((String)"two filters, one is empty, should not match anything", (long)0L, (long)ftQuery.getResultSize());
    }

    @Test
    public void testMultipleFiltersOfSameTypeWithDifferentParameters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("fieldConstraintFilter-1").setParameter("field", (Object)"teacher").setParameter("value", (Object)"andre");
        ftQuery.enableFullTextFilter("fieldConstraintFilter-2").setParameter("field", (Object)"teacher").setParameter("value", (Object)"aaron");
        Assert.assertEquals((String)"Should apply both filters resulting in 0 results", (long)0L, (long)ftQuery.getResultSize());
    }

    @Test
    public void testFilterDefinedOnSuperClass() {
        TermQuery query = new TermQuery(new Term("employer", "Red Hat"));
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)query, new Class[]{Employee.class});
        ftQuery.enableFullTextFilter("roleFilter").setParameter("role", (Object)Employee.Role.ADMINISTRATOR);
        Assert.assertEquals((String)"Should find the filter defined in the super class", (long)1L, (long)ftQuery.getResultSize());
    }

    @Test
    public void testUnknownFilterNameThrowsException() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        try {
            ftQuery.enableFullTextFilter("foo");
            Assert.fail((String)"Retrieving an unknown filter should throw a SearchException");
        }
        catch (SearchException e) {
            Assert.assertEquals((String)"Wrong message", (Object)"HSEARCH000115: Unknown @FullTextFilter: 'foo'", (Object)e.getMessage());
        }
    }

    private void createData() {
        try (Session s = this.openSession();){
            s.getTransaction().begin();
            Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
            cal.set(2006, 10, 11);
            Driver driver = new Driver();
            driver.setDelivery(cal.getTime());
            driver.setId(1);
            driver.setName("Emmanuel");
            driver.setScore(5);
            driver.setTeacher("andre");
            s.persist((Object)driver);
            cal.set(2007, 10, 11);
            driver = new Driver();
            driver.setDelivery(cal.getTime());
            driver.setId(2);
            driver.setName("Gavin");
            driver.setScore(3);
            driver.setTeacher("aaron");
            s.persist((Object)driver);
            cal.set(2004, 10, 11);
            driver = new Driver();
            driver.setDelivery(cal.getTime());
            driver.setId(3);
            driver.setName("Liz");
            driver.setScore(5);
            driver.setTeacher("max");
            s.persist((Object)driver);
            String employer = "Red Hat";
            Employee employee = new FullTimeEmployee();
            employee.setId(1);
            employee.setFullName("John D Doe");
            employee.setRole(Employee.Role.ADMINISTRATOR);
            employee.setEmployer(employer);
            s.persist((Object)employee);
            employee = new FullTimeEmployee();
            employee.setId(2);
            employee.setFullName("Mary S. Doe");
            employee.setRole(Employee.Role.DEVELOPER);
            employee.setEmployer(employer);
            s.persist((Object)employee);
            employee = new PartTimeEmployee();
            employee.setId(3);
            employee.setFullName("Dave Connor");
            employee.setRole(Employee.Role.CONSULTANT);
            employee.setEmployer(employer);
            s.persist((Object)employee);
            s.getTransaction().commit();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.cachingPolicy = IndexSearcher.getDefaultQueryCachingPolicy();
        IndexSearcher.setDefaultQueryCachingPolicy((QueryCachingPolicy)QueryCachingPolicy.ALWAYS_CACHE);
        this.createData();
        this.query = this.createQuery();
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.fullTextSession.getTransaction().begin();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            this.fullTextSession.getTransaction().commit();
            this.fullTextSession.close();
        }
        finally {
            if (this.cachingPolicy != null) {
                IndexSearcher.setDefaultQueryCachingPolicy((QueryCachingPolicy)this.cachingPolicy);
            }
        }
        super.tearDown();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Driver.class, Soap.class, FullTimeEmployee.class, PartTimeEmployee.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.filter.cache_docidresults.size", "10");
        InstanceBasedExcludeAllFilterFactory.reset();
    }

    private BooleanQuery createQuery() {
        return new BooleanQuery.Builder().add((Query)new TermQuery(new Term("teacher", "andre")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("teacher", "max")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("teacher", "aaron")), BooleanClause.Occur.SHOULD).build();
    }
}

