/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.integration;

import java.util.LinkedHashSet;
import java.util.Properties;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.HibernateSearchIntegrator;
import org.hibernate.search.hcore.impl.SearchFactoryReference;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.junit.Before;
import org.junit.Test;
import org.unitils.UnitilsJUnit4;
import org.unitils.easymock.EasyMockUnitils;
import org.unitils.easymock.annotation.Mock;

public class HibernateSearchIntegratorTest
extends UnitilsJUnit4 {
    private static final Boolean SEARCH_DISABLED = Boolean.FALSE;
    private static final Boolean SEARCH_ENABLED = Boolean.TRUE;
    private static final Boolean SEARCH_IMPLICITLY_ENABLED = null;
    @Mock
    private SessionFactoryServiceRegistry mockSessionFactoryServiceRegistry;
    @Mock
    private SessionFactoryImplementor mockSessionFactoryImplementor;
    @Mock
    private EventListenerRegistry mockEventListenerRegistry;
    @Mock
    private ClassLoaderService mockClassLoaderService;
    private HibernateSearchIntegrator integratorUnderTest;

    @Before
    public void setUp() {
        this.integratorUnderTest = new HibernateSearchIntegrator();
    }

    @Test
    public void testEventListenersAreNotRegisteredIfSearchIsExplicitlyDisabledInConfiguration() {
        Configuration cfg = HibernateSearchIntegratorTest.makeConfiguration(SEARCH_DISABLED);
        EasyMockUnitils.replay();
        this.integratorUnderTest.integrate(cfg, this.mockSessionFactoryImplementor, this.mockSessionFactoryServiceRegistry);
    }

    @Test
    public void testEventListenersAreRegisteredIfSearchIsExplicitlyEnabledInConfiguration() {
        Configuration cfg = HibernateSearchIntegratorTest.makeConfiguration(SEARCH_ENABLED);
        this.assertObserverCalledAndEventListenersRegistered(cfg);
    }

    @Test
    public void testEventListenersAreRegisteredIfSearchIsImplicitlyEnabledInConfiguration() {
        Configuration cfg = HibernateSearchIntegratorTest.makeConfiguration(SEARCH_IMPLICITLY_ENABLED);
        this.assertObserverCalledAndEventListenersRegistered(cfg);
    }

    private void assertObserverCalledAndEventListenersRegistered(Configuration cfg) {
        Capture capturedSessionFactoryObserver = new Capture();
        this.mockSessionFactoryImplementor.addObserver((SessionFactoryObserver)EasyMock.and((Object)EasyMock.capture((Capture)capturedSessionFactoryObserver), (Object)EasyMock.isA(SessionFactoryObserver.class)));
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.getService(EventListenerRegistry.class)).andReturn((Object)this.mockEventListenerRegistry);
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.getService(SearchFactoryReference.class)).andReturn((Object)new SearchFactoryReference());
        this.mockEventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)EasyMock.isA(HibernateSearchIntegrator.DuplicationStrategyImpl.class));
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_INSERT), (Object[])new PostInsertEventListener[]{(PostInsertEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_UPDATE), (Object[])new PostUpdateEventListener[]{(PostUpdateEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_DELETE), (Object[])new PostDeleteEventListener[]{(PostDeleteEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_COLLECTION_RECREATE), (Object[])new PostCollectionRecreateEventListener[]{(PostCollectionRecreateEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_COLLECTION_REMOVE), (Object[])new PostCollectionRemoveEventListener[]{(PostCollectionRemoveEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_COLLECTION_UPDATE), (Object[])new PostCollectionUpdateEventListener[]{(PostCollectionUpdateEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.FLUSH), (Object[])new FlushEventListener[]{(FlushEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.getService(ClassLoaderService.class)).andReturn((Object)this.mockClassLoaderService);
        EasyMock.expect((Object)this.mockSessionFactoryImplementor.getServiceRegistry()).andReturn((Object)this.mockSessionFactoryServiceRegistry);
        EasyMock.expect((Object)this.mockClassLoaderService.classForName("javax.persistence.Id")).andReturn(Object.class);
        EasyMock.expect((Object)this.mockClassLoaderService.loadJavaServices(BridgeProvider.class)).andReturn(new LinkedHashSet(0));
        EasyMockUnitils.replay();
        this.integratorUnderTest.integrate(cfg, this.mockSessionFactoryImplementor, this.mockSessionFactoryServiceRegistry);
        ((SessionFactoryObserver)capturedSessionFactoryObserver.getValue()).sessionFactoryCreated((SessionFactory)this.mockSessionFactoryImplementor);
    }

    private static Configuration makeConfiguration(Boolean enableSearch) {
        Configuration cfg = new Configuration();
        Properties properties = new Properties();
        cfg.setProperties(properties);
        if (enableSearch != null) {
            properties.setProperty("hibernate.search.autoregister_listeners", String.valueOf(enableSearch));
        }
        return cfg;
    }
}

