/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1494")
public class EmbeddedObjectIdInclusionTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest((SearchConfiguration)searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testIncludeEmbeddedObjectId() {
        TypeMetadata typeMetadata = this.metadataProvider.getTypeMetadataFor(A1.class);
        Assert.assertTrue((String)"There should be only one embedded metadata instance", (typeMetadata.getEmbeddedTypeMetadata().size() == 1 ? 1 : 0) != 0);
        EmbeddedTypeMetadata embeddedTypeMetadata = (EmbeddedTypeMetadata)typeMetadata.getEmbeddedTypeMetadata().get(0);
        PropertyMetadata propertyMetadata = embeddedTypeMetadata.getPropertyMetadataForProperty("id");
        Assert.assertNotNull((String)"The id property should have been included", (Object)propertyMetadata);
    }

    @Test
    public void testExcludeEmbeddedObjectId() {
        TypeMetadata typeMetadata = this.metadataProvider.getTypeMetadataFor(A2.class);
        Assert.assertTrue((String)"There should be only one embedded metadata instance", (typeMetadata.getEmbeddedTypeMetadata().size() == 1 ? 1 : 0) != 0);
        EmbeddedTypeMetadata embeddedTypeMetadata = (EmbeddedTypeMetadata)typeMetadata.getEmbeddedTypeMetadata().get(0);
        PropertyMetadata propertyMetadata = embeddedTypeMetadata.getPropertyMetadataForProperty("id");
        Assert.assertNull((String)"The id property should not have been included", (Object)propertyMetadata);
    }

    @Entity
    public class B {
        @Id
        @GeneratedValue
        private long id;
    }

    @Entity
    @Indexed
    public class A2 {
        @Id
        @GeneratedValue
        private long id;
        @OneToOne
        @IndexedEmbedded(includeEmbeddedObjectId=false)
        private B b;
    }

    @Entity
    @Indexed
    public class A1 {
        @Id
        @GeneratedValue
        private long id;
        @OneToOne
        @IndexedEmbedded(includeEmbeddedObjectId=true)
        private B b;
    }
}

