/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.reader.nrtreaders;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.AlternateDocument;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.junit.Assert;
import org.junit.Test;

public class BasicNRTFunctionalityTest
extends SearchTestBase {
    @Test
    public void testEntityResurrection() {
        Long id = 5L;
        Session session = this.getSessionFactory().openSession();
        session.getTransaction().begin();
        AlternateDocument docOnInfinispan = new AlternateDocument(id, "On Infinispan", "a book about Infinispan", "content");
        session.persist((Object)docOnInfinispan);
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(AlternateDocument.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("Abstract").matching((Object)"Infinispan").createQuery();
        List list = fullTextSession.createFullTextQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((long)1L, (long)list.size());
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        Object loadedDocument = session.load(AlternateDocument.class, (Serializable)id);
        session.delete(loadedDocument);
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        list = fullTextSession.createFullTextQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((long)0L, (long)list.size());
        AlternateDocument docOnHibernate = new AlternateDocument(id, "On Hibernate", "a book about Hibernate", "content");
        session.persist((Object)docOnHibernate);
        session.getTransaction().commit();
        session.getTransaction().begin();
        list = fullTextSession.createFullTextQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((long)0L, (long)list.size());
        session.close();
    }

    @Test
    public void testMultipleEntitiesPerIndex() throws Exception {
        ExtendedSearchIntegrator integrator = ContextHelper.getSearchintegratorBySFI((SessionFactoryImplementor)((SessionFactoryImplementor)this.getSessionFactory()));
        IndexManager documentsIndexManager = integrator.getIndexManagerHolder().getIndexManager("Documents");
        Assert.assertNotNull((Object)documentsIndexManager);
        Assert.assertTrue((boolean)documentsIndexManager.getClass().equals(NRTIndexManager.class));
        NRTIndexManager indexManager = (NRTIndexManager)documentsIndexManager;
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        Document document = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
        s.persist((Object)document);
        s.flush();
        s.persist((Object)new AlternateDocument(document.getId(), "Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        Assert.assertEquals((long)0L, (long)this.getDocumentNbrFromFilesystem(indexManager));
        Assert.assertEquals((long)2L, (long)this.getDocumentNbrFromReaderProvider(indexManager));
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        TermQuery q = new TermQuery(new Term("alt_title", "hibernate"));
        Assert.assertEquals((String)"does not properly filter", (long)0L, (long)Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class}).list().size());
        Assert.assertEquals((String)"does not properly filter", (long)1L, (long)Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class, AlternateDocument.class}).list().size());
        s.delete(s.get(AlternateDocument.class, (Serializable)document.getId()));
        s.getTransaction().commit();
        s.close();
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        Assert.assertEquals((long)0L, (long)this.getDocumentNbrFromFilesystem(indexManager));
        Assert.assertEquals((long)1L, (long)this.getDocumentNbrFromQuery(s));
        Assert.assertEquals((long)1L, (long)this.getDocumentNbrFromReaderProvider(indexManager));
        s.delete(s.createCriteria(Document.class).uniqueResult());
        s.getTransaction().commit();
        s.close();
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        Assert.assertEquals((long)0L, (long)this.getDocumentNbrFromFilesystem(indexManager));
        Assert.assertEquals((long)0L, (long)this.getDocumentNbrFromQuery(s));
        Assert.assertEquals((long)0L, (long)this.getDocumentNbrFromReaderProvider(indexManager));
        s.getTransaction().commit();
        s.close();
        ErrorHandler errorHandler = integrator.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        MockErrorHandler mockErrorHandler = (MockErrorHandler)errorHandler;
        Assert.assertNull((String)"Errors detected in the backend!", (Object)mockErrorHandler.getLastException());
    }

    private int getDocumentNbrFromQuery(Session currentSession) {
        MatchAllDocsQuery luceneQuery = new MatchAllDocsQuery();
        FullTextQuery fullTextQuery = Search.getFullTextSession((Session)currentSession).createFullTextQuery((Query)luceneQuery, new Class[]{Document.class});
        return fullTextQuery.list().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbrFromReaderProvider(NRTIndexManager indexManager) {
        IndexReader reader = indexManager.getReaderProvider().openIndexReader();
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            indexManager.getReaderProvider().closeIndexReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbrFromFilesystem(NRTIndexManager documentsIndexManager) throws Exception {
        try (DirectoryReader reader = DirectoryReader.open((Directory)documentsIndexManager.getDirectoryProvider().getDirectory());){
            int n = reader.numDocs();
            return n;
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class, AlternateDocument.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.indexmanager", "near-real-time");
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

