/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

final class StreamWrappingTokenizer
extends Tokenizer {
    private final OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final String[] tokens;
    private int position = 0;

    public StreamWrappingTokenizer(Reader input, String[] tokens) {
        super(input);
        this.tokens = tokens;
    }

    public boolean incrementToken() throws IOException {
        if (this.position >= this.tokens.length) {
            return false;
        }
        this.clearAttributes();
        String token = this.tokens[this.position++];
        this.termAttribute.append(token);
        this.offsetAttribute.setOffset(0, token.length());
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.position = 0;
    }
}

