/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;

@Entity
@Indexed
public class Cd {
    @Id
    @GeneratedValue
    private int id;
    @Field
    private String name;
    @Field(analyze=Analyze.NO)
    @Facet
    private int price;
    @Field(analyze=Analyze.NO)
    @DateBridge(resolution=Resolution.YEAR)
    @Facet
    private Date releaseYear;

    public Cd() {
    }

    public Cd(String name, int price, String releaseYear) {
        this.name = name;
        this.price = price;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        try {
            this.releaseYear = formatter.parse(releaseYear);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("wrong date format");
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPrice() {
        return this.price;
    }

    public Date getReleaseYear() {
        return this.releaseYear;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cd");
        sb.append("{id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", price=").append(this.price);
        sb.append(", releaseYear=").append(this.releaseYear);
        sb.append('}');
        return sb.toString();
    }
}

