/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Company;
import org.hibernate.search.test.query.facet.CompanyFacility;
import org.junit.Assert;
import org.junit.Test;

public class ManyToOneFacetingTest
extends AbstractFacetTest {
    private final String indexFieldName = "companyFacilities.country";
    private final String facetName = "countryFacility";

    @Test
    public void testAllIndexedManyToOneValuesGetCounted() throws Exception {
        FacetingRequest request = this.queryBuilder(Company.class).facet().name("countryFacility").onField("companyFacilities.country").discrete().includeZeroCounts(true).createFacetingRequest();
        FullTextQuery query = this.queryCompanyWithFacet(request);
        List facetList = query.getFacetManager().getFacets("countryFacility");
        Assert.assertEquals((String)"Wrong number of facets", (long)2L, (long)facetList.size());
        for (Facet item : facetList) {
            Assert.assertEquals((String)"Wrong count of facet", (long)1L, (long)item.getCount());
        }
    }

    private FullTextQuery queryCompanyWithFacet(FacetingRequest request) {
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
        query.getFacetManager().enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of query matches", (long)1L, (long)query.getResultSize());
        return query;
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        Company acme = new Company("ACME");
        CompanyFacility usFacility = new CompanyFacility("US");
        usFacility.setCompany(acme);
        acme.addCompanyFacility(usFacility);
        CompanyFacility indiaFacility = new CompanyFacility("INDIA");
        indiaFacility.setCompany(acme);
        acme.addCompanyFacility(indiaFacility);
        session.save((Object)acme);
        tx.commit();
        session.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Company.class, CompanyFacility.class};
    }
}

