/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.junit.Assert;
import org.junit.Test;

public class NumberFacetingTest
extends AbstractFacetTest {
    @Test
    public void testSimpleFaceting() throws Exception {
        String indexFieldName = "cubicCapacity";
        String facetName = "ccs";
        FacetingRequest request = this.queryBuilder(Car.class).facet().name(facetName).onField(indexFieldName).discrete().createFacetingRequest();
        FullTextQuery query = this.matchAll(request);
        List facetList = query.getFacetManager().getFacets(facetName);
        Assert.assertEquals((String)"Wrong number of facets", (long)4L, (long)facetList.size());
        this.assertFacet((Facet)facetList.get(0), "2407", 17);
        this.assertFacet((Facet)facetList.get(1), "2831", 16);
        this.assertFacet((Facet)facetList.get(2), "3398", 16);
        this.assertFacet((Facet)facetList.get(3), "2500", 1);
    }

    private void assertFacet(Facet facet, String expectedCubicCapacity, int expectedCount) {
        Assert.assertEquals((String)"Wrong facet value", (Object)expectedCubicCapacity, (Object)facet.getValue());
        Assert.assertEquals((String)"Wrong facet count", (long)expectedCount, (long)facet.getCount());
    }

    private FullTextQuery matchAll(FacetingRequest request) {
        MatchAllDocsQuery luceneQuery = new MatchAllDocsQuery();
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)luceneQuery, new Class[]{Car.class});
        query.getFacetManager().enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of indexed cars", (long)50L, (long)query.getResultSize());
        return query;
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                }
            }
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        tx.commit();
        session.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class};
    }
}

