/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SerializationTestHelper;
import org.hibernate.search.test.configuration.ConfigurationReadTestCase;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.junit.Assert;
import org.junit.Test;

public class LuceneIndexingParametersTest
extends ConfigurationReadTestCase {
    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.search.default.indexwriter.ram_buffer_size", "1");
        cfg.put("hibernate.search.default.indexwriter.merge_calibrate_by_deletes", "false");
        cfg.put("hibernate.search.default.indexwriter.max_merge_docs", "9");
        cfg.put("hibernate.search.Book.indexwriter.max_merge_docs", "12");
        cfg.put("hibernate.search.Book.indexwriter.merge_calibrate_by_deletes", "false");
        cfg.put("hibernate.search.Book.indexwriter.merge_factor", "13");
        cfg.put("hibernate.search.Book.indexwriter.max_buffered_docs", "14");
        cfg.put("hibernate.search.Book.indexwriter.ram_buffer_size", "4");
        cfg.put("hibernate.search.Book.indexwriter.merge_max_optimize_size", "256");
        cfg.put("hibernate.search.Documents.indexwriter.ram_buffer_size", "default");
        cfg.put("hibernate.search.Documents.indexwriter.merge_factor", "6");
        cfg.put("hibernate.search.Documents.indexwriter.max_buffered_docs", "7");
        cfg.put("hibernate.search.Documents.indexwriter.max_merge_docs", "9");
        cfg.put("hibernate.search.Documents.indexwriter.max_field_length", "9");
    }

    @Test
    public void testDefaultIndexProviderParameters() {
        this.assertValueIsSet(Author.class, IndexWriterSetting.MERGE_CALIBRATE_BY_DELETES, 0);
        this.assertValueIsSet(Author.class, IndexWriterSetting.RAM_BUFFER_SIZE, 1);
        this.assertValueIsSet(Author.class, IndexWriterSetting.MAX_MERGE_DOCS, 9);
        this.assertValueIsSet(Author.class, IndexWriterSetting.MAX_BUFFERED_DOCS, 1000);
        this.assertValueIsSet(Author.class, IndexWriterSetting.MERGE_FACTOR, 100);
    }

    @Test
    public void testSpecificTypeParametersOverride() {
        this.assertValueIsSet(Book.class, IndexWriterSetting.MAX_MERGE_DOCS, 12);
        this.assertValueIsSet(Book.class, IndexWriterSetting.MAX_BUFFERED_DOCS, 14);
        this.assertValueIsSet(Book.class, IndexWriterSetting.MERGE_FACTOR, 13);
        this.assertValueIsSet(Book.class, IndexWriterSetting.MERGE_CALIBRATE_BY_DELETES, 0);
        this.assertValueIsSet(Book.class, IndexWriterSetting.RAM_BUFFER_SIZE, 4);
        this.assertValueIsSet(Book.class, IndexWriterSetting.MERGE_MAX_OPTIMIZE_SIZE, 256);
    }

    @Test
    public void testDefaultKeywordOverwritesInherited() {
        this.assertValueIsDefault(Document.class, IndexWriterSetting.RAM_BUFFER_SIZE);
    }

    @Test
    public void testSerializability() throws IOException, ClassNotFoundException {
        LuceneIndexingParameters param = new LuceneIndexingParameters(new Properties());
        LuceneIndexingParameters paramCopy = SerializationTestHelper.duplicateBySerialization(param);
        Assert.assertEquals((Object)param.getIndexParameters(), (Object)paramCopy.getIndexParameters());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, Document.class};
    }
}

